/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import umcg.genetica.console.ProgressBar;

public class WGAFileMatrixGenotype {
    public int nrSNPs = 0;
    public int nrInds = 0;
    private RandomAccessFile file = null;

    public WGAFileMatrixGenotype(int nrSNPs, int nrInds, File fileName, boolean readOnly) throws IOException {
        this.nrSNPs = nrSNPs;
        this.nrInds = nrInds;
        if (readOnly) {
            System.out.println("Opening genotype matrix file: " + fileName);
            this.file = new RandomAccessFile(fileName, "r");
        } else {
            this.file = new RandomAccessFile(fileName, "rw");
        }
        long fileSize = 2L * (long)nrSNPs * (long)nrInds;
        if (!readOnly && this.file.length() != fileSize) {
            ProgressBar pb = new ProgressBar(fileSize, "Creating genotype matrix for " + nrSNPs + " SNPS and " + nrInds + " individuals. Eventual size: " + fileSize);
            this.file.seek(0L);
            int buffersize = 1000;
            if (fileSize > 4096L) {
                buffersize = 4096;
            }
            byte[] byteString = new byte[buffersize];
            for (int g = 0; g < buffersize; ++g) {
                byteString[g] = 0;
            }
            for (long x = 0L; x < fileSize - (long)buffersize; x += (long)buffersize) {
                this.file.write(byteString);
                if (x % 0x1000000L != 0L) continue;
                pb.set(x);
            }
            long remainder = fileSize % (long)buffersize;
            if (remainder > 0L) {
                byte[] byteSingle = new byte[(int)remainder];
                this.file.write(byteSingle);
            }
            pb.close();
            System.out.println("Size genotype matrix:\t" + fileSize + "\tFile size:\t" + this.file.length());
        }
    }

    private long getElement(int snp, int ind) {
        return 2L * (long)snp * (long)this.nrInds + (long)ind;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public byte getAllele1(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        return this.file.readByte();
    }

    public byte getAllele2(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        return this.file.readByte();
    }

    public void setAllele1(int snp, int ind, byte value) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }

    public void setAllele1(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }

    public void setAllele2(int snp, int ind, byte value) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        this.file.write(value);
    }

    public void setAllele2(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        this.file.write(value);
    }

    public void setAlleles(int snp, byte[] alleles1, byte[] alleles2) throws IOException {
        this.file.seek(2L * (long)snp * (long)this.nrInds);
        this.file.write(alleles1);
        this.file.seek(2L * (long)snp * (long)this.nrInds + (long)this.nrInds);
        this.file.write(alleles2);
    }
}

