/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import umcg.genetica.math.stats.Descriptives;
import umcg.genetica.math.stats.HWE;

public class SNP {
    private byte chr;
    private int chrPos;
    private int id;
    private String name;
    private byte[] dosage;
    private byte[] alleles1;
    private byte[] alleles2;
    private double HWEP = 1.0;
    private double MAF = -1.0;
    private double DOSAGEMAF = -1.0;
    private double CR = 0.0;
    private byte[] genotypes;
    private double[] alleleFreq;
    private byte minorAllele = 0;
    private boolean passesQC;
    private byte[] alleles;
    public int nrCalled;
    private int[] genotypeFreq;
    private byte alleleItr;

    public byte getAlleleItr() {
        return this.alleleItr;
    }

    public void setChr(byte chr) {
        this.chr = chr;
    }

    public void setChrPos(int chrPos) {
        this.chrPos = chrPos;
    }

    public byte getChr() {
        return this.chr;
    }

    public int getChrPos() {
        return this.chrPos;
    }

    public void setId(int snpId) {
        this.id = snpId;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String snp) {
        this.name = snp;
    }

    public String getName() {
        return this.name;
    }

    public void setAlleles(byte[] allele1, byte[] allele2, Boolean[] indIncluded, Boolean[] indIsFemale) {
        this.alleles1 = allele1;
        this.alleles2 = allele2;
        this.genotypes = new byte[allele1.length];
        this.alleles = new byte[3];
        this.alleleItr = 0;
        int missingGenotypes = 0;
        this.genotypeFreq = new int[3];
        int nrTotal = 0;
        this.nrCalled = 0;
        for (int ind = 0; ind < this.alleles1.length; ++ind) {
            Boolean inc = indIncluded[ind];
            if (inc != null && inc.booleanValue() && (this.chr != 23 || indIsFemale[ind] == null || indIsFemale[ind].booleanValue())) {
                ++nrTotal;
            }
            if (allele1[ind] != 0 && allele2[ind] != 0 && inc != null && inc.booleanValue()) {
                byte genotypeCode;
                int i;
                if (this.chr != 23 || indIsFemale[ind] == null || indIsFemale[ind].booleanValue()) {
                    ++this.nrCalled;
                }
                int allelecode1 = -1;
                int allelecode2 = -1;
                for (i = 0; i < 2; i = (int)((byte)(i + 1))) {
                    if (this.alleles[i] != allele1[ind]) continue;
                    allelecode1 = i;
                }
                if (allelecode1 == -1) {
                    this.alleles[this.alleleItr] = allele1[ind];
                    allelecode1 = this.alleleItr;
                    this.alleleItr = (byte)(this.alleleItr + 1);
                    if (this.alleleItr > 2) {
                        System.out.println("ERROR!!!: Number of different alleles for SNP\t" + this.name + "\t is more than two!");
                        System.out.println("Allele 1:\t" + this.alleles[0] + " / " + new String(new byte[]{this.alleles[0]}));
                        System.out.println("Allele 2:\t" + this.alleles[1] + " / " + new String(new byte[]{this.alleles[1]}));
                        System.out.println("Allele 3:\t" + this.alleles[2] + " / " + new String(new byte[]{this.alleles[2]}));
                        break;
                    }
                }
                for (i = 0; i < 2; i = (int)((byte)(i + 1))) {
                    if (this.alleles[i] != allele2[ind]) continue;
                    allelecode2 = i;
                }
                if (allelecode2 == -1) {
                    this.alleles[this.alleleItr] = allele2[ind];
                    allelecode2 = this.alleleItr;
                    this.alleleItr = (byte)(this.alleleItr + 1);
                    if (this.alleleItr > 2) {
                        System.out.println("ERROR!!!: Number of different alleles for SNP\t" + this.name + "\t is more than two!");
                        System.out.println("Allele 1:\t" + this.alleles[0] + " / " + new String(new byte[]{this.alleles[0]}));
                        System.out.println("Allele 2:\t" + this.alleles[1] + " / " + new String(new byte[]{this.alleles[1]}));
                        System.out.println("Allele 3:\t" + this.alleles[2] + " / " + new String(new byte[]{this.alleles[2]}));
                        break;
                    }
                }
                this.genotypes[ind] = genotypeCode = (byte)(allelecode1 + allelecode2);
                if (this.chr == 23 && indIsFemale[ind] != null && !indIsFemale[ind].booleanValue()) continue;
                byte by = genotypeCode;
                this.genotypeFreq[by] = this.genotypeFreq[by] + 1;
                continue;
            }
            if (inc != null && inc.booleanValue()) {
                ++missingGenotypes;
            }
            this.genotypes[ind] = -1;
        }
        this.alleleFreq = new double[2];
        this.alleleFreq[0] = 2 * this.genotypeFreq[0] + this.genotypeFreq[1];
        this.alleleFreq[1] = 2 * this.genotypeFreq[2] + this.genotypeFreq[1];
        this.MAF = this.alleleFreq[0] / ((double)this.nrCalled * 2.0);
        this.minorAllele = this.alleles[0];
        if (this.alleleFreq[0] > this.alleleFreq[1]) {
            this.minorAllele = this.alleles[1];
            this.MAF = 1.0 - this.MAF;
        }
        this.HWEP = HWE.calculateExactHWEPValue(this.genotypeFreq[1], this.genotypeFreq[0], this.genotypeFreq[2]);
        this.passesQC = false;
        this.CR = (double)this.nrCalled / (double)nrTotal;
        if (this.genotypeFreq[0] > 0 && this.genotypeFreq[1] > 0 || this.genotypeFreq[1] > 0 && this.genotypeFreq[2] > 0 || this.genotypeFreq[0] > 0 && this.genotypeFreq[2] > 0) {
            this.passesQC = true;
        }
    }

    public void setPassesQC(boolean b) {
        this.passesQC = b;
    }

    public boolean passesQC() {
        return this.passesQC;
    }

    public double getHWEP() {
        return this.HWEP;
    }

    public void setHWEP(Double HWEP) {
        this.HWEP = HWEP;
    }

    public double getMAF() {
        return this.MAF;
    }

    public double getDosageMAF() {
        return this.DOSAGEMAF;
    }

    public void setMAF(Double MAF) {
        this.MAF = MAF;
    }

    public double getCR() {
        return this.CR;
    }

    public void setCR(Double CR) {
        this.CR = CR;
    }

    public void setAlleles(byte[] allele1, byte[] allele2) {
        this.alleles1 = allele1;
        this.alleles2 = allele2;
    }

    public void clearGenotypes() {
        this.alleles1 = null;
        this.alleles2 = null;
        this.genotypes = null;
        this.alleleFreq = null;
        this.dosage = null;
    }

    public byte[] getAllele1() {
        return this.alleles1;
    }

    public byte[] getAllele2() {
        return this.alleles2;
    }

    public byte[] getGenotypes() {
        return this.genotypes;
    }

    public void setDosage(byte[] dosageValues) {
        this.dosage = dosageValues;
        double[] dosages = this.getDosageValues();
        this.DOSAGEMAF = Descriptives.mean(dosages) / 2.0;
        if (this.DOSAGEMAF > 0.5) {
            this.DOSAGEMAF = 1.0 - this.DOSAGEMAF;
        }
    }

    public double[] getDosageValues() {
        if (this.dosage != null) {
            double[] dosagevalues = new double[this.dosage.length];
            for (int i = 0; i < this.dosage.length; ++i) {
                dosagevalues[i] = (double)(128 + this.dosage[i]) / 100.0;
            }
            return dosagevalues;
        }
        return null;
    }

    public boolean hasDosageInformation() {
        return this.dosage != null;
    }

    public double[] selectGenotypes(int[] ids) {
        return this.selectGenotypes(ids, false, true);
    }

    public double[] selectGenotypes(short[] phenotypeToGenotypeId, boolean includeMissingGenotypes, boolean loadDosageWhenAvailable) {
        int[] idsInt = new int[phenotypeToGenotypeId.length];
        for (int i = 0; i < phenotypeToGenotypeId.length; ++i) {
            idsInt[i] = phenotypeToGenotypeId[i];
        }
        return this.selectGenotypes(idsInt, includeMissingGenotypes, loadDosageWhenAvailable);
    }

    public double[] selectGenotypes(int[] phenotypeToGenotypeId, boolean includeMissingGenotypes, boolean loadDosageWhenAvailable) {
        int i;
        int numReq = phenotypeToGenotypeId.length;
        int numAvail = 0;
        for (i = 0; i < numReq; ++i) {
            if (!includeMissingGenotypes && this.genotypes[phenotypeToGenotypeId[i]] == -1 || phenotypeToGenotypeId[i] == -1) continue;
            ++numAvail;
        }
        double[] gtypes = new double[numAvail];
        int q = 0;
        for (i = 0; i < numReq; ++i) {
            double dosagevalue;
            int l_id = phenotypeToGenotypeId[i];
            if (l_id == -1 || !includeMissingGenotypes && this.genotypes[l_id] == -1) continue;
            gtypes[q] = this.dosage != null && loadDosageWhenAvailable ? (dosagevalue = (double)(128 + this.dosage[l_id]) / 100.0) : (double)this.genotypes[l_id];
            ++q;
        }
        return gtypes;
    }

    public byte[] getAlleles() {
        return this.alleles;
    }

    public void setAlleleCodes(byte[] alleles) {
        this.alleles = alleles;
    }

    public byte getMinorAllele() {
        return this.minorAllele;
    }

    public double[] getAlleleFreq() {
        return this.alleleFreq;
    }

    public int[] getGenotypeFreq() {
        return this.genotypeFreq;
    }

    public void setGenotypeFreq(int[] genotypeFreq) {
        this.genotypeFreq = genotypeFreq;
    }

    public void setMinorAllele(byte minorAllele) {
        this.minorAllele = minorAllele;
    }

    public void setNrCalled(int nrCalled) {
        this.nrCalled = nrCalled;
    }

    public int getNrCalled() {
        return this.nrCalled;
    }
}

