/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.text.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.io.text.TextFile;

public class NetworkConverter {
    private static final Logger LOGGER = Logger.getLogger(NetworkConverter.class.getName());

    private NetworkConverter() {
    }

    public static void convertPlainTextDoubleMatrixToPlainTextEdgeList(String matrixfile, String outfile, String infileDelimiter, String outfileDelimiter) throws IOException {
        TextFile in = new TextFile(matrixfile, false);
        String line = in.readLine();
        String[] split = line.split(infileDelimiter);
        String[] nodes = Arrays.copyOfRange(split, 1, split.length);
        LOGGER.log(Level.FINE, "{0} nodes in {1}", new Object[]{nodes.length, matrixfile});
        TextFile out = new TextFile(outfile, true);
        int lineNr = 1;
        int nrEdges = 0;
        while ((line = in.readLine()) != null) {
            split = line.split(infileDelimiter);
            if (split.length != nodes.length + 1) {
                throw new IllegalArgumentException("The data in file '" + matrixfile + "' are not a matrix. Check line " + (lineNr + 1) + ".");
            }
            String node = split[0];
            for (int i = 1; i < split.length; ++i) {
                if (lineNr == i) continue;
                try {
                    double weight = Double.parseDouble(split[i]);
                    if (!(weight > 0.0)) continue;
                    out.writeln(node + outfileDelimiter + nodes[i - 1] + outfileDelimiter + weight);
                    ++nrEdges;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("The data in file '" + matrixfile + "' are not numerical (cast to double failed). Check line " + (lineNr + 1) + ", column " + (i + 1) + ".");
                }
            }
            ++lineNr;
        }
        in.close();
        out.close();
        LOGGER.log(Level.FINE, "{0} edges from {1} written to ''{2}''", new Object[]{nrEdges, matrixfile, outfile});
    }

    public static void writeGMTFileBasedOnGeneSetFileAndMappingFileRemovingDuplicateGeneSets(String genesetfile, String mappingfile, String mappingdelimiter, String gmtfile) throws IOException {
        String line;
        TextFile in = new TextFile(mappingfile, false);
        in.readLine();
        HashMap<String, String> code2name = new HashMap<String, String>();
        while ((line = in.readLine()) != null) {
            String[] split = line.split(mappingdelimiter);
            String name = split[2].trim().replace("\"", "") + " (" + split[6].trim() + ")";
            code2name.put(split[0].trim().replace("\"", ""), name);
        }
        in.close();
        System.out.println(code2name.size() + " gene set annotations read");
        in = new TextFile(genesetfile, false);
        TextFile out = new TextFile(gmtfile, true);
        HashMap<String, Integer> usedNames = new HashMap<String, Integer>();
        HashSet<String> usedGeneSets = new HashSet<String>();
        while ((line = in.readLine()) != null) {
            String[] split = line.split("\t");
            if (split.length == 0) continue;
            String code = split[0].trim();
            String name = (String)code2name.get(code);
            if (name == null) {
                LOGGER.log(Level.WARNING, "No annotation for gene set ''{0}''", code);
                continue;
            }
            String genes = Arrays.asList(Arrays.copyOfRange(split, 1, split.length)).toString();
            System.out.println(genes);
            if (usedGeneSets.contains(genes)) continue;
            Integer oldNrItems = (Integer)usedNames.get(name);
            if (oldNrItems == null) {
                out.write(code + "\t" + name);
                for (int i = 1; i < split.length; ++i) {
                    out.write("\t" + split[i]);
                }
                out.writeln();
                usedNames.put(name, split.length - 1);
                usedGeneSets.add(genes);
                continue;
            }
            System.out.println("Sets with different numbers of genes for " + name);
        }
        in.close();
        out.close();
    }

    public static void convertGMTFileToPlainTextBinaryNetwork(String infile, String outfile, boolean hasIds, boolean isActuallyGMT) throws IOException {
        String line;
        TextFile in = new TextFile(infile, false);
        HashMap<String, Integer> hashItems = new HashMap<String, Integer>();
        HashMap<String, HashSet<Integer>> hashSetIndices = new HashMap<String, HashSet<Integer>>();
        ArrayList<String> sets = new ArrayList<String>();
        int nextIndex = 0;
        int nrItemSets = 0;
        while ((line = in.readLine()) != null) {
            int firstItemIndex;
            String[] split = line.split("\t");
            if (split.length == 0) continue;
            int n = hasIds ? (isActuallyGMT ? 2 : 1) : (firstItemIndex = 0);
            if (hasIds) {
                sets.add(split[0]);
            }
            for (int i = firstItemIndex; i < split.length; ++i) {
                HashSet<Integer> setIndicesThisItem;
                Integer itemIndex = (Integer)hashItems.get(split[i]);
                if (itemIndex == null) {
                    hashItems.put(split[i], nextIndex);
                    ++nextIndex;
                }
                if ((setIndicesThisItem = (HashSet<Integer>)hashSetIndices.get(split[i])) == null) {
                    setIndicesThisItem = new HashSet<Integer>();
                    hashSetIndices.put(split[i], setIndicesThisItem);
                }
                setIndicesThisItem.add(nrItemSets);
            }
            ++nrItemSets;
        }
        in.close();
        TextFile out = new TextFile(outfile, true);
        for (int i = 0; i < nrItemSets; ++i) {
            if (hasIds) {
                out.write("\t" + (String)sets.get(i));
                continue;
            }
            out.write("\tComplex" + (i + 1));
        }
        out.writeln();
        for (String item : hashSetIndices.keySet()) {
            if ("".equals(item)) continue;
            out.write(item);
            Set setIndicesThisItem = (Set)hashSetIndices.get(item);
            for (int set = 0; set < nrItemSets; ++set) {
                if (setIndicesThisItem.contains(set)) {
                    out.write("\t1");
                    continue;
                }
                out.write("\t0");
            }
            out.writeln();
        }
        out.close();
    }
}

