/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.regulomedb;

import java.util.regex.Pattern;

public class RegulomeDbSupportingData {
    private final String supportClass;
    private final String supportMethod;
    private final String supportValue;
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");

    public RegulomeDbSupportingData(String supportData) throws Exception {
        String[] supportDataElements = PIPE_PATTERN.split(supportData);
        if (supportDataElements.length == 3) {
            this.supportClass = supportDataElements[0];
            this.supportMethod = supportDataElements[1];
            this.supportValue = supportDataElements[2];
        } else if (supportDataElements.length == 2) {
            this.supportClass = supportDataElements[0];
            this.supportMethod = supportDataElements[1];
            this.supportValue = "";
        } else if (supportDataElements.length == 4) {
            this.supportClass = supportDataElements[0];
            this.supportMethod = supportDataElements[1];
            this.supportValue = supportDataElements[2] + "|" + supportDataElements[3];
        } else {
            throw new Exception("Error in RegulomeDB support data. Expected three elements separated by | found: " + supportData);
        }
    }

    public String getSupportClass() {
        return this.supportClass;
    }

    public String getSupportMethod() {
        return this.supportMethod;
    }

    public String getSupportValue() {
        return this.supportValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.supportClass != null ? this.supportClass.hashCode() : 0);
        hash = 29 * hash + (this.supportMethod != null ? this.supportMethod.hashCode() : 0);
        hash = 29 * hash + (this.supportValue != null ? this.supportValue.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegulomeDbSupportingData other = (RegulomeDbSupportingData)obj;
        if (this.supportClass == null ? other.supportClass != null : !this.supportClass.equals(other.supportClass)) {
            return false;
        }
        if (this.supportMethod == null ? other.supportMethod != null : !this.supportMethod.equals(other.supportMethod)) {
            return false;
        }
        return !(this.supportValue == null ? other.supportValue != null : !this.supportValue.equals(other.supportValue));
    }
}

