/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import umcg.genetica.io.text.TextFile;

public class GMTFile {
    List<String> pathways = new ArrayList<String>();
    Map<String, Set<String>> genesInPathways = new HashMap<String, Set<String>>();

    public GMTFile(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Error loading GMT file: no file specified.");
        }
        this.read(file);
    }

    private void read(String gmtfile) throws IOException {
        String[] pwelems;
        System.out.println("Reading GMT file: " + gmtfile);
        TextFile tfpathway = new TextFile(gmtfile, false);
        while ((pwelems = tfpathway.readLineElems(TextFile.tab)) != null) {
            if (pwelems.length <= 2) continue;
            this.pathways.add(pwelems[0]);
            HashSet<String> genes = new HashSet<String>();
            for (int i = 2; i < pwelems.length; ++i) {
                genes.add(pwelems[i]);
            }
            this.genesInPathways.put(pwelems[0], genes);
        }
        tfpathway.close();
        System.out.println(this.pathways.size() + " pathways loaded.");
    }

    public List<String> getPathways() {
        return this.pathways;
    }

    public Set<String> getGenesForPathway(String pathway) {
        return this.genesInPathways.get(pathway);
    }

    public Map<String, Set<String>> getPathwayToGenes() {
        return this.genesInPathways;
    }
}

