/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.genomicboundaries;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umcg.genetica.genomicboundaries.GenomicBoundariesIterator;
import umcg.genetica.genomicboundaries.GenomicBoundary;

public class GenomicBoundaries<V>
implements Iterable<GenomicBoundary<V>> {
    private HashMap<String, TreeMap<Integer, ArrayList<GenomicBoundary<V>>>> genomicsBoundaries = new HashMap();
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^#");
    private static final Pattern CHR_PATTERN = Pattern.compile("^chr(.*)$", 2);
    private int margin = 0;
    private boolean removedSubBoundaries = false;
    private String feature;

    public GenomicBoundaries(String genomicsBoundarysFilePath) throws FileNotFoundException, IOException {
        String line;
        BufferedReader genomicsBoundarysReader = new BufferedReader(new FileReader(genomicsBoundarysFilePath));
        while ((line = genomicsBoundarysReader.readLine()) != null) {
            ArrayList boundaries;
            TreeMap<Object, Object> chromosomeBoundaries;
            if (COMMENT_PATTERN.matcher(line).find()) continue;
            String[] cells = TAB_PATTERN.split(line);
            String chromosome = GenomicBoundaries.removeChr(cells[0]);
            Integer beginPoint = Integer.valueOf(cells[1]);
            int endPoint = Integer.parseInt(cells[2]);
            if (!this.genomicsBoundaries.containsKey(chromosome)) {
                chromosomeBoundaries = new TreeMap();
                this.genomicsBoundaries.put(chromosome, chromosomeBoundaries);
            } else {
                chromosomeBoundaries = this.genomicsBoundaries.get(chromosome);
            }
            GenomicBoundary genomicBoundary = new GenomicBoundary(chromosome, beginPoint, endPoint);
            int n = chromosomeBoundaries.size();
            if (chromosomeBoundaries.containsKey(beginPoint) && ((GenomicBoundary)((ArrayList)chromosomeBoundaries.get(beginPoint)).get(n - 1)).getStop() >= endPoint) continue;
            if (chromosomeBoundaries.containsKey(beginPoint)) {
                boundaries = (ArrayList)chromosomeBoundaries.get(beginPoint);
            } else {
                boundaries = new ArrayList();
                chromosomeBoundaries.put(beginPoint, boundaries);
            }
            boundaries.add(genomicBoundary);
        }
        this.removeSubBoundaries();
    }

    public GenomicBoundaries() {
    }

    public final void addBoundary(String chromosome, Integer beginPoint, int endPoint) {
        ArrayList boundaries;
        TreeMap<Object, Object> chromosomeBoundaries;
        if (!this.genomicsBoundaries.containsKey(chromosome = GenomicBoundaries.removeChr(chromosome))) {
            chromosomeBoundaries = new TreeMap();
            this.genomicsBoundaries.put(chromosome, chromosomeBoundaries);
        } else {
            chromosomeBoundaries = this.genomicsBoundaries.get(chromosome);
        }
        GenomicBoundary genomicBoundary = new GenomicBoundary(chromosome, beginPoint, endPoint);
        if (chromosomeBoundaries.containsKey(beginPoint)) {
            boundaries = (ArrayList)chromosomeBoundaries.get(beginPoint);
        } else {
            boundaries = new ArrayList();
            chromosomeBoundaries.put(beginPoint, boundaries);
        }
        boundaries.add(genomicBoundary);
        this.removedSubBoundaries = false;
    }

    public final void removeSubBoundaries() {
        GenomicBoundary<V> previousGenomicBoundary = null;
        Iterator<GenomicBoundary<V>> gboit = this.iterator();
        while (gboit.hasNext()) {
            GenomicBoundary<V> genomicBoundary = gboit.next();
            System.out.println("cur: " + genomicBoundary.getStart() + "-" + genomicBoundary.getStop());
            if (genomicBoundary.isPartOfBoundary(previousGenomicBoundary)) {
                System.out.println("REMOVING");
                gboit.remove();
            }
            previousGenomicBoundary = genomicBoundary;
        }
        this.removedSubBoundaries = true;
    }

    public final void mergeOverlappingBoundaries() {
        this.removeSubBoundaries();
        HashMap genomicsBoundariesMergedOverlappingBoundaries = new HashMap();
        for (Map.Entry<String, TreeMap<Integer, ArrayList<GenomicBoundary<V>>>> chromosomeBoundariesEntry : this.genomicsBoundaries.entrySet()) {
            ArrayList boundaries;
            TreeMap<Integer, ArrayList<GenomicBoundary<V>>> chromosomeBoundaries = chromosomeBoundariesEntry.getValue();
            TreeMap<Integer, ArrayList> chromosomeBoundariesMergedOverlappingBoundaries = new TreeMap<Integer, ArrayList>();
            GenomicBoundary<V> currentGenomicBoundary = null;
            for (ArrayList<GenomicBoundary<V>> genomicBoundaryList : chromosomeBoundaries.values()) {
                for (GenomicBoundary<V> genomicBoundary : genomicBoundaryList) {
                    if (currentGenomicBoundary == null) {
                        currentGenomicBoundary = genomicBoundary;
                    }
                    if (!currentGenomicBoundary.isOverlaping(genomicBoundary)) {
                        ArrayList boundaries2;
                        if (!chromosomeBoundariesMergedOverlappingBoundaries.containsKey(currentGenomicBoundary.getStart())) {
                            boundaries2 = new ArrayList();
                            boundaries2.add(currentGenomicBoundary);
                            chromosomeBoundariesMergedOverlappingBoundaries.put(currentGenomicBoundary.getStart(), boundaries2);
                        } else {
                            boundaries2 = (ArrayList)chromosomeBoundariesMergedOverlappingBoundaries.get(currentGenomicBoundary.getStart());
                            boundaries2.add(currentGenomicBoundary);
                        }
                        currentGenomicBoundary = genomicBoundary;
                        continue;
                    }
                    currentGenomicBoundary = new GenomicBoundary(currentGenomicBoundary.getChromosome(), Math.min(currentGenomicBoundary.getStart(), genomicBoundary.getStart()), Math.max(currentGenomicBoundary.getStop(), genomicBoundary.getStop()));
                }
            }
            if (!chromosomeBoundariesMergedOverlappingBoundaries.containsKey(currentGenomicBoundary.getStart())) {
                boundaries = new ArrayList();
                boundaries.add(currentGenomicBoundary);
                chromosomeBoundariesMergedOverlappingBoundaries.put(currentGenomicBoundary.getStart(), boundaries);
            } else {
                boundaries = (ArrayList)chromosomeBoundariesMergedOverlappingBoundaries.get(currentGenomicBoundary.getStart());
                boundaries.add(currentGenomicBoundary);
            }
            genomicsBoundariesMergedOverlappingBoundaries.put(chromosomeBoundariesEntry.getKey(), chromosomeBoundariesMergedOverlappingBoundaries);
        }
        this.genomicsBoundaries = genomicsBoundariesMergedOverlappingBoundaries;
    }

    public GenomicBoundaries(String genomicsBoundarysFilePath, int margin) throws FileNotFoundException, IOException {
        this(genomicsBoundarysFilePath);
        this.margin = margin;
    }

    public boolean isChromosomeInBoundary(String chromosome) {
        return this.genomicsBoundaries.containsKey(chromosome);
    }

    public Set<String> getChromosomes() {
        return this.genomicsBoundaries.keySet();
    }

    public boolean isInBoundary(String chromosome, int position, int listIndex) {
        return this.getBoundary(chromosome, position, listIndex) != null;
    }

    public GenomicBoundary getBoundary(String chromosome, int position, int listIndex) {
        ArrayList<GenomicBoundary<V>> boundary;
        TreeMap<Integer, ArrayList<GenomicBoundary<V>>> chromosomeBoudaries;
        Map.Entry<Integer, ArrayList<GenomicBoundary<V>>> boundaryEntry;
        if (this.isChromosomeInBoundary(chromosome) && (boundaryEntry = (chromosomeBoudaries = this.genomicsBoundaries.get(chromosome)).floorEntry(position + this.margin)) != null && (boundary = boundaryEntry.getValue()).get(listIndex).isInBoundarie(position, this.margin)) {
            return boundary.get(listIndex);
        }
        return null;
    }

    private static String removeChr(String chromosome) {
        Matcher chrMatcher = CHR_PATTERN.matcher(chromosome);
        if (chrMatcher.find()) {
            return chrMatcher.group(1);
        }
        return chromosome;
    }

    @Override
    public Iterator<GenomicBoundary<V>> iterator() {
        return new GenomicBoundariesIterator<V>(this.genomicsBoundaries);
    }

    public int getBoundaryCountChromosome(String chromosome) {
        if (this.isChromosomeInBoundary(chromosome)) {
            return this.genomicsBoundaries.get(chromosome).size();
        }
        return 0;
    }

    public int getBoudaryCount() {
        int count = 0;
        for (TreeMap<Integer, ArrayList<GenomicBoundary<V>>> chrBoundaries : this.genomicsBoundaries.values()) {
            count += chrBoundaries.size();
        }
        return count;
    }

    public void writeBoundariesToBedFile(String bedFilePath, String trackName) throws IOException {
        BufferedWriter bedBufferWriter = new BufferedWriter(new FileWriter(bedFilePath));
        bedBufferWriter.append("track name=\"" + trackName + "\"\n");
        for (GenomicBoundary<V> genomicBoundary : this) {
            bedBufferWriter.append("chr" + genomicBoundary.getChromosome() + "\t" + genomicBoundary.getStart() + "\t" + genomicBoundary.getStop() + "\n");
        }
        bedBufferWriter.close();
    }

    public TreeMap<Integer, ArrayList<GenomicBoundary<V>>> getGenomicBoundariesMap(String chromosome) throws Exception {
        if (!this.genomicsBoundaries.containsKey(chromosome)) {
            throw new Exception("Chromosome: " + chromosome + " doesn't exist.");
        }
        return this.genomicsBoundaries.get(chromosome);
    }

    public Collection<ArrayList<GenomicBoundary<V>>> getGenomicBoundaries(String chromosome) throws Exception {
        return this.getGenomicBoundariesMap(chromosome).values();
    }

    public void mergeGenomicBoundaries(GenomicBoundaries otherGenomicBoundariesSet) {
        HashMap<String, TreeMap<Integer, ArrayList<GenomicBoundary<V>>>> otherGenomicBoundaries = otherGenomicBoundariesSet.getGenomicBoundaries();
        for (Map.Entry<String, TreeMap<Integer, ArrayList<GenomicBoundary<V>>>> chromosomeBoundariesEntry : otherGenomicBoundaries.entrySet()) {
            TreeMap<Integer, ArrayList<GenomicBoundary<V>>> chromosomeBoundaries = chromosomeBoundariesEntry.getValue();
            for (ArrayList<GenomicBoundary<V>> genomicBoundaryList : chromosomeBoundaries.values()) {
                for (GenomicBoundary<V> genomicBoundary : genomicBoundaryList) {
                    if (!this.genomicsBoundaries.containsKey(genomicBoundary.getChromosome())) {
                        ArrayList<GenomicBoundary<V>> aap = new ArrayList<GenomicBoundary<V>>();
                        aap.add(genomicBoundary);
                        this.genomicsBoundaries.get(genomicBoundary.getChromosome()).put(genomicBoundary.getStart(), aap);
                        continue;
                    }
                    this.genomicsBoundaries.get(genomicBoundary.getChromosome()).get(genomicBoundary.getStart()).add(genomicBoundary);
                }
            }
        }
    }

    public HashMap<String, TreeMap<Integer, ArrayList<GenomicBoundary<V>>>> getGenomicBoundaries() {
        return this.genomicsBoundaries;
    }

    public final void addBoundary(String chromosome, Integer beginPoint, int endPoint, V annotation) {
        ArrayList boundaries;
        TreeMap<Object, Object> chromosomeBoundaries;
        if (!this.genomicsBoundaries.containsKey(chromosome = GenomicBoundaries.removeChr(chromosome))) {
            chromosomeBoundaries = new TreeMap();
            this.genomicsBoundaries.put(chromosome, chromosomeBoundaries);
        } else {
            chromosomeBoundaries = this.genomicsBoundaries.get(chromosome);
        }
        GenomicBoundary<V> genomicBoundary = new GenomicBoundary<V>(chromosome, beginPoint, endPoint, annotation);
        if (chromosomeBoundaries.containsKey(beginPoint)) {
            boundaries = (ArrayList)chromosomeBoundaries.get(beginPoint);
        } else {
            boundaries = new ArrayList();
            chromosomeBoundaries.put(beginPoint, boundaries);
        }
        boundaries.add(genomicBoundary);
        this.removedSubBoundaries = false;
    }
}

