/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.process;

import java.util.Stack;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.Interpreter;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.process.ProcessInterface;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.logger.Logger;

public abstract class Process
extends EventProducer
implements ProcessInterface {
    protected short state = 0;
    protected Stack frameStack = new Stack();

    public Process() {
        try {
            this.frameStack.push(Interpreter.createFrame(this, ClassUtil.resolveMethod((Object)this, (String)"process", null), null));
        }
        catch (Exception exception) {
            Logger.warning((Object)this, (String)"<init>", (Throwable)exception);
        }
    }

    public abstract void process();

    public void resume() {
        if (this.state == 1 || this.state == 3) {
            throw new IllegalStateException("Cannot resume a process in state==executing||dead");
        }
        if (this.frameStack.isEmpty()) {
            this.setState((short)3);
            return;
        }
        try {
            this.setState((short)1);
            ((Frame)this.frameStack.peek()).setPaused(false);
            Interpreter.interpret(this.frameStack);
        }
        catch (InterpreterException exception) {
            exception.printStackTrace();
            Logger.warning((Object)this, (String)"<init>", (Throwable)exception);
        }
    }

    public final void suspend() {
        throw new IllegalStateException("suspend should be interpreted. One may not invoke this method directly. If this exception occurs, make sure that the method that invoked it, was interpreted.");
    }

    protected final void setState(short state) {
        if (this.state == 2 && state == 2) {
            throw new IllegalStateException("Cannot suspend a suspended process");
        }
        this.state = state;
        super.fireEvent(ProcessInterface.STATE_CHANGE_EVENT, state);
    }

    public short getState() {
        return this.state;
    }
}

