/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.deelenp.genotypeharmonizer;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import nl.umcg.deelenp.genotypeharmonizer.Aligner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.GenotypedDataWriterFormats;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.modifiable.ModifiableGenotypeData;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import org.molgenis.genotype.tabix.TabixFileNotFoundException;
import org.molgenis.genotype.util.LdCalculatorException;

class GenotypeHarmonizer {
    private static final String VERSION = ResourceBundle.getBundle("verion").getString("application.version");
    private static final String HEADER = "  /---------------------------------------\\\n  |          Genotype Harmonizer          |\n  |                                       |\n  |             Patrick Deelen            |\n  |        patrickdeelen@gmail.com        |\n  |                                       |\n  | Harm-Jan Westra, Joeri van der Velde, |\n  |    Marc Jan Bonder, Erwin Winder,     |\n  |      Lude Franke, Morris Swertz       |\n  |                                       |\n  |     Genomics Coordication Center      |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/";
    private static final Logger LOGGER;
    private static final Options OPTIONS;
    private static final int DEFAULT_MIN_VARIANTS_TO_ALIGN_ON = 3;
    private static final int DEFAULT_FLANK_VARIANTS_TO_CONSIDER = 100;
    private static final int MIN_MIN_VARIANTS_TO_ALIGN_ON = 3;
    private static final double DEFAULT_MIN_LD_TO_INCLUDE_ALIGN = 0.3;
    private static final double DEFAULT_MAX_MAF_FOR_MAF_ALIGNMENT = 0.0;
    private static final double DEFAULT_MINIMUM_POSTERIOR_PROBABILITY = 0.4;
    private static final DateFormat DATE_TIME_FORMAT;

    GenotypeHarmonizer() {
    }

    public static void main(String ... args) throws InterruptedException {
        ModifiableGenotypeData aligedInputData;
        RandomAccessGenotypeData refData;
        RandomAccessGenotypeData inputData;
        double minimumPosteriorProbability;
        double maxMafForMafAlignment;
        double minLdToIncludeAlign;
        int flankSnpsToConsider;
        int minSnpsToAlignOn;
        GenotypedDataWriterFormats outputType;
        RandomAccessGenotypeDataReaderFormats refType;
        String refBasePath;
        RandomAccessGenotypeDataReaderFormats inputType;
        String inputBasePath;
        CommandLine commandLine;
        Date currentDataTime;
        block66: {
            System.out.println(HEADER);
            System.out.println();
            System.out.println("          --- Version: " + VERSION + " ---");
            System.out.println();
            System.out.println("More information: http://molgenis.org/systemsgenetics");
            System.out.println();
            currentDataTime = new Date();
            System.out.println("Current date and time: " + DATE_TIME_FORMAT.format(currentDataTime));
            System.out.println();
            System.out.flush();
            Thread.sleep(25L);
            if (args.length == 0) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(" ", OPTIONS);
                System.exit(1);
            }
            PosixParser parser = new PosixParser();
            try {
                commandLine = parser.parse(OPTIONS, args, true);
            }
            catch (ParseException ex) {
                System.err.println("Invalid command line arguments: ");
                System.err.println(ex.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(" ", OPTIONS);
                System.exit(1);
                return;
            }
            inputBasePath = commandLine.getOptionValue('i');
            try {
                if (commandLine.hasOption('I')) {
                    inputType = RandomAccessGenotypeDataReaderFormats.valueOf(commandLine.getOptionValue('I').toUpperCase());
                    break block66;
                }
                if (inputBasePath.endsWith(".vcf")) {
                    System.err.println("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                }
                try {
                    inputType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath(inputBasePath);
                }
                catch (GenotypeDataException e) {
                    System.err.println("Unable to determine input type based on specified path. Please specify --inputType");
                    System.exit(1);
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing --inputType \"" + commandLine.getOptionValue('I') + "\" is not a valid input data format");
                System.exit(1);
                return;
            }
        }
        if (commandLine.hasOption('r')) {
            refBasePath = commandLine.getOptionValue('r');
            try {
                if (commandLine.hasOption('R')) {
                    refType = RandomAccessGenotypeDataReaderFormats.valueOf(commandLine.getOptionValue('R').toUpperCase());
                }
                if (refBasePath.endsWith(".vcf")) {
                    System.err.println("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                    System.exit(1);
                    return;
                }
                try {
                    refType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath(refBasePath);
                }
                catch (GenotypeDataException e) {
                    System.err.println("Unable to determine reference type based on specified path. Please specify --refType");
                    System.exit(1);
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing --refType \"" + commandLine.getOptionValue('R') + "\" is not a valid reference data format");
                System.exit(1);
                return;
            }
        } else {
            refBasePath = null;
            refType = null;
        }
        String outputBasePath = commandLine.getOptionValue('o');
        if (commandLine.hasOption('O')) {
            try {
                outputType = GenotypedDataWriterFormats.valueOf(commandLine.getOptionValue('O').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing --outputType \"" + commandLine.getOptionValue('O') + "\" is not a valid output data format");
                System.exit(1);
                return;
            }
        }
        try {
            outputType = GenotypedDataWriterFormats.valueOf(inputType.name());
        }
        catch (IllegalArgumentException e) {
            outputType = GenotypedDataWriterFormats.PLINK_BED;
        }
        boolean debugMode = commandLine.hasOption('d');
        boolean updateId = commandLine.hasOption("id");
        try {
            minSnpsToAlignOn = commandLine.hasOption('m') ? Integer.parseInt(commandLine.getOptionValue('m')) : 3;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing --min-variants \"" + commandLine.getOptionValue('m') + "\" is not an int");
            System.exit(1);
            return;
        }
        try {
            flankSnpsToConsider = commandLine.hasOption('v') ? Integer.parseInt(commandLine.getOptionValue('v')) : 100;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing --variants \"" + commandLine.getOptionValue('v') + "\" is not an int");
            System.exit(1);
            return;
        }
        try {
            minLdToIncludeAlign = commandLine.hasOption('l') ? Double.parseDouble(commandLine.getOptionValue('l')) : 0.3;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing --min-ld \"" + commandLine.getOptionValue('s') + "\" is not a double");
            System.exit(1);
            return;
        }
        try {
            maxMafForMafAlignment = commandLine.hasOption("ma") ? Double.parseDouble(commandLine.getOptionValue("ma")) : 0.0;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing --mafAlign \"" + commandLine.getOptionValue("ma") + "\" is not a double");
            System.exit(1);
            return;
        }
        try {
            minimumPosteriorProbability = commandLine.hasOption("ip") ? Double.parseDouble(commandLine.getOptionValue("ip")) : 0.4;
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing --inputProb \"" + commandLine.getOptionValue("ip") + "\" is not an int");
            System.exit(1);
            return;
        }
        String forceSeqName = commandLine.hasOption('f') ? commandLine.getOptionValue('f') : null;
        boolean ldCheck = commandLine.hasOption('c');
        boolean keep = commandLine.hasOption('k');
        File logFile = new File(outputBasePath + ".log");
        File snpUpdateFile = new File(outputBasePath + ".idUpdates");
        if (logFile.getParentFile() != null && !logFile.getParentFile().isDirectory() && !logFile.getParentFile().mkdirs()) {
            System.err.println("Failed to create output folder: " + logFile.getParent());
            System.exit(1);
        }
        try {
            FileAppender logAppender = new FileAppender((Layout)new SimpleLayout(), logFile.getCanonicalPath(), false);
            LOGGER.getRootLogger().removeAllAppenders();
            LOGGER.getRootLogger().addAppender((Appender)logAppender);
            if (debugMode) {
                LOGGER.setLevel(Level.DEBUG);
            } else {
                LOGGER.setLevel(Level.INFO);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create logger: " + e.getMessage());
            System.exit(1);
        }
        LOGGER.info((Object)"\n  /---------------------------------------\\\n  |          Genotype Harmonizer          |\n  |                                       |\n  |             Patrick Deelen            |\n  |        patrickdeelen@gmail.com        |\n  |                                       |\n  | Harm-Jan Westra, Joeri van der Velde, |\n  |    Marc Jan Bonder, Erwin Winder,     |\n  |      Lude Franke, Morris Swertz       |\n  |                                       |\n  |     Genomics Coordication Center      |\n  |  University Medical Center Groningen  |\n  \\---------------------------------------/");
        LOGGER.info((Object)("Version: " + VERSION));
        LOGGER.info((Object)("Current date and time: " + DATE_TIME_FORMAT.format(currentDataTime)));
        LOGGER.info((Object)("Log level: " + LOGGER.getLevel()));
        System.out.println("Started logging");
        System.out.println();
        GenotypeHarmonizer.printOptions(inputBasePath, inputType, refBasePath, refType, outputBasePath, outputType, minSnpsToAlignOn, flankSnpsToConsider, minLdToIncludeAlign, ldCheck, debugMode, updateId, keep, forceSeqName, maxMafForMafAlignment, minimumPosteriorProbability);
        if (minSnpsToAlignOn < 3) {
            LOGGER.fatal((Object)"the specified --min-variants < 3");
            System.err.println("the specified --min-variants < 3");
            System.exit(1);
            return;
        }
        if ((double)flankSnpsToConsider < minLdToIncludeAlign) {
            LOGGER.fatal((Object)"--variants < --min-variants");
            System.err.println("--variants < --min-variants");
            System.exit(1);
            return;
        }
        if (inputBasePath.equals(refBasePath)) {
            LOGGER.fatal((Object)"Study data and reference data cannot be the same data");
            System.err.println("Study data and reference data cannot be the same data");
            System.exit(1);
            return;
        }
        if (inputBasePath.equals(outputBasePath)) {
            LOGGER.fatal((Object)"Study input can not be the same as output");
            System.err.println("Study input can not be the same as output");
            System.exit(1);
            return;
        }
        if (forceSeqName != null && inputType != RandomAccessGenotypeDataReaderFormats.SHAPEIT2 && inputType != RandomAccessGenotypeDataReaderFormats.GEN) {
            System.err.println("Error cannot force sequence name of: " + inputType.getName());
            System.exit(1);
            return;
        }
        int genotypeDataCache = flankSnpsToConsider * 4;
        try {
            inputData = inputType.createGenotypeData(inputBasePath, genotypeDataCache, forceSeqName, minimumPosteriorProbability);
        }
        catch (TabixFileNotFoundException e) {
            System.err.println("Tabix file not found for input data at: " + e.getPath() + "\n" + "Please see README on how to create a tabix file");
            LOGGER.fatal((Object)("Tabix file not found for input data at: " + e.getPath() + "\n" + "Please see README on how to create a tabix file"));
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("Error reading input data: " + e.getMessage());
            LOGGER.fatal((Object)("Error reading input data: " + e.getMessage()), (Throwable)e);
            System.exit(1);
            return;
        }
        catch (IncompatibleMultiPartGenotypeDataException e) {
            System.err.println("Error combining the impute genotype data files: " + e.getMessage());
            LOGGER.fatal((Object)("Error combining the impute genotype data files: " + e.getMessage()), (Throwable)e);
            System.exit(1);
            return;
        }
        catch (GenotypeDataException e) {
            System.err.println("Error reading input data: " + e.getMessage());
            LOGGER.fatal((Object)("Error reading input data: " + e.getMessage()), (Throwable)e);
            System.exit(1);
            return;
        }
        System.out.println("Input data loaded");
        LOGGER.info((Object)"Input data loaded");
        if (refBasePath != null) {
            try {
                refData = refType.createGenotypeData(refBasePath, genotypeDataCache);
            }
            catch (TabixFileNotFoundException e) {
                System.err.println("Tabix file not found for reference data at: " + e.getPath() + "\n" + "Please see README on how to create a tabix file");
                LOGGER.fatal((Object)("Tabix file not found for reference data at: " + e.getPath() + "\n" + "Please see README on how to create a tabix file"));
                System.exit(1);
                return;
            }
            catch (IOException e) {
                System.err.println("Error reading reference data: " + e.getMessage());
                LOGGER.fatal((Object)("Error reading reference data: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (IncompatibleMultiPartGenotypeDataException e) {
                System.err.println("Error combining the reference genotype data files: " + e.getMessage());
                LOGGER.fatal((Object)("Error combining the reference genotype data files: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (GenotypeDataException e) {
                System.err.println("Error reading reference data: " + e.getMessage());
                LOGGER.fatal((Object)("Error reading reference data: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            System.out.println("Reference data loaded");
            LOGGER.info((Object)"Reference data loaded");
            Aligner aligner = new Aligner();
            try {
                System.out.println("Beginning alignment");
                aligedInputData = aligner.alignToRef(inputData, refData, minLdToIncludeAlign, minSnpsToAlignOn, flankSnpsToConsider, ldCheck, updateId, keep, snpUpdateFile, maxMafForMafAlignment);
            }
            catch (LdCalculatorException e) {
                System.err.println("Error in LD calculation" + e.getMessage());
                LOGGER.fatal((Object)("Error in LD calculation" + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (GenotypeDataException e) {
                System.err.println("Error in alignment" + e.getMessage());
                LOGGER.fatal((Object)("Error in alignment" + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (IOException e) {
                System.err.println("Error in alignment" + e.getMessage());
                LOGGER.fatal((Object)("Error in alignment" + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            System.out.println("Alignment complete");
            LOGGER.info((Object)"Alignment complete");
            System.out.println("Excluded in total " + aligedInputData.getExcludedVariantCount() + " variants");
            LOGGER.info((Object)("Excluded in total " + aligedInputData.getExcludedVariantCount() + " variants"));
        } else {
            refData = null;
            aligedInputData = null;
            System.out.println("No reference specified. Do conversion without alignment");
            LOGGER.info((Object)"No reference specified. Do conversion without alignment");
        }
        if (inputType == RandomAccessGenotypeDataReaderFormats.SHAPEIT2 && outputType == GenotypedDataWriterFormats.PLINK_BED) {
            System.out.println("WARNING: converting phased SHAPEIT2 data to binary Plink data. A BED file stores AB genotypes in the same manner as BA genotypes, thus all phasing will be lost.");
            LOGGER.warn((Object)"WARNING: converting phased SHAPEIT2 data to binary Plink data. A BED file stores AB genotypes in the same manner as BA genotypes, thus all phasing will be lost.");
        }
        if (outputType == GenotypedDataWriterFormats.GEN && !inputData.isOnlyContaingSaveProbabilityGenotypes()) {
            System.out.println("WARNING: writing dosage genotype data to .gen posterior probabilities file. Using heuristic method to convert to probabilities, this is not guaranteed to be accurate. See manual for more details.");
            LOGGER.warn((Object)"WARNING: writing dosage genotype data to .gen posterior probabilities file. Using heuristic method to convert to probabilities, this is not guaranteed to be accurate. See manual for more details.");
        }
        System.out.println("Writing results");
        LOGGER.info((Object)"Writing results");
        try {
            GenotypeWriter inputDataWriter = outputType.createGenotypeWriter(aligedInputData == null ? inputData : aligedInputData);
            inputDataWriter.write(outputBasePath);
        }
        catch (IOException e) {
            System.err.println("Error writing output data: " + e.getMessage());
            LOGGER.fatal((Object)("Error writing output data: " + e.getMessage()), (Throwable)e);
            System.exit(1);
            return;
        }
        catch (GenotypeDataException e) {
            System.err.println("Error writing output data: " + e.getMessage());
            LOGGER.fatal((Object)("Error writing output data: " + e.getMessage()), (Throwable)e);
            System.exit(1);
            return;
        }
        try {
            inputData.close();
            if (refData != null) {
                refData.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        LOGGER.info((Object)"Output data written");
        LOGGER.info((Object)"Program complete");
        System.out.println("Output data written");
        System.out.println("Program complete");
    }

    private static void printOptions(String inputBasePath, RandomAccessGenotypeDataReaderFormats inputType, String refBasePath, RandomAccessGenotypeDataReaderFormats refType, String outputBasePath, GenotypedDataWriterFormats outputType, int minSnpsToAlignOn, int flankSnpsToConsider, double minLdToIncludeAlign, boolean ldCheck, boolean debugMode, boolean updateId, boolean keep, String forceSeqName, double maxMafForMafAlignment, double minimumPosteriorProbability) {
        System.out.println("Interpreted arguments: ");
        System.out.println(" - Input base path: " + inputBasePath);
        LOGGER.info((Object)("Input base path: " + inputBasePath));
        System.out.println(" - Input data type: " + inputType.getName());
        LOGGER.info((Object)("Input data type: " + inputType.getName()));
        System.out.println(" - Reference base path: " + (refBasePath == null ? "no reference set" : refBasePath));
        LOGGER.info((Object)("Reference base path: " + (refBasePath == null ? "no reference set" : refBasePath)));
        System.out.println(" - Reference data type: " + (refBasePath == null ? "no reference set" : refType.getName()));
        LOGGER.info((Object)("Reference data type: " + (refBasePath == null ? "no reference set" : refType.getName())));
        System.out.println(" - Output base path: " + outputBasePath);
        LOGGER.info((Object)("Output base path: " + outputBasePath));
        System.out.println(" - Output data type: " + outputType.getName());
        LOGGER.info((Object)("Output data type: " + outputType.getName()));
        System.out.println(" - Number of flank variants to consider for LD alignment: " + flankSnpsToConsider);
        LOGGER.info((Object)("Number of flank variants to consider for LD alignment: " + flankSnpsToConsider));
        System.out.println(" - Minimum LD of flanking variants before using for LD alignment: " + minLdToIncludeAlign);
        LOGGER.info((Object)("Minimum LD of flanking variants before using for LD alignment: " + minLdToIncludeAlign));
        System.out.println(" - Minimum number of variants needed to for LD alignment: " + minSnpsToAlignOn);
        LOGGER.info((Object)("Minimum number of variants needed to for LD alignment: " + minSnpsToAlignOn));
        System.out.println(" - Maximum MAF of variants to use minor allele as backup for alignment: " + maxMafForMafAlignment);
        LOGGER.info((Object)("Maximum MAF of variants to use minor allele as backup for alignment: " + maxMafForMafAlignment));
        System.out.println(" - Minimum posterior probability for input data: " + minimumPosteriorProbability);
        LOGGER.info((Object)("Minimum posterior probability for input data: " + minimumPosteriorProbability));
        System.out.println(" - LD checker " + (ldCheck ? "on" : "off"));
        LOGGER.info((Object)("LD checker " + (ldCheck ? "on" : "off")));
        System.out.println(" - Update study IDs: " + (updateId ? "yes" : "no"));
        LOGGER.info((Object)("Update study variant IDs: " + (updateId ? "yes" : "no")));
        LOGGER.info((Object)("Keep variants not in reference data: " + (keep ? "yes" : "no")));
        System.out.println(" - Keep variants not in reference data: " + (keep ? "yes" : "no"));
        LOGGER.info((Object)("Force input sequence name: " + (forceSeqName == null ? "not forcing" : "forcing to: " + forceSeqName)));
        System.out.println(" - Force input sequence name: " + (forceSeqName == null ? "not forcing" : "forcing to: " + forceSeqName));
        LOGGER.info((Object)("Debug mode: " + (debugMode ? "on" : "off")));
        System.out.println();
    }

    static {
        DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LOGGER = Logger.getLogger(GenotypeHarmonizer.class);
        OPTIONS = new Options();
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The base path of the data to align. The extensions are determined based on the input data type.");
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.isRequired();
        Option option = OptionBuilder.create((String)"i");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The base bath of the reference data. The extensions are determined based on the reference data type.");
        OptionBuilder.withLongOpt((String)"ref");
        option = OptionBuilder.create((String)"r");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The input data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample");
        OptionBuilder.withLongOpt((String)"inputType");
        option = OptionBuilder.create((String)"I");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The reference data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCF_FOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample");
        OptionBuilder.withLongOpt((String)"refType");
        option = OptionBuilder.create((String)"R");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The output bash path");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.isRequired();
        option = OptionBuilder.create((String)"o");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The output data type. Defaults to --inputType or to PLINK_BED if there is no writer for the impute type.\n* PED_MAP - plink PED MAP files\n* PLINK_BED - plink BED BIM FAM files\n* SHAPEIT2 - shapeit2 phased haplotypes\n* GEN - Oxford .gen & .sample");
        OptionBuilder.withLongOpt((String)"outputType");
        option = OptionBuilder.create((String)"O");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Number of variants on either flank to consider using for LD-strand alignment. Must be equal or larger than --min-variants. Defaults to 100");
        OptionBuilder.withLongOpt((String)"variants");
        option = OptionBuilder.create((String)"v");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Minimum LD between variant to align or check and a flanking variants in both input as reference. Defaults to 0.3. It is NOT recommend to set this to zero");
        OptionBuilder.withLongOpt((String)"min-ld");
        option = OptionBuilder.create((String)"l");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Minimum number of variants above ld-cutoff to do LD alignment. Variants that do not meet this requirement are excluded. Defaults to 3. Min value: 3");
        OptionBuilder.withLongOpt((String)"min-variants");
        option = OptionBuilder.create((String)"m");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Check ld structure of all variants after alignment and exclude variants that deviate. This option negates the effect of --mafAlign");
        OptionBuilder.withLongOpt((String)"check-ld");
        option = OptionBuilder.create((String)"c");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Activate debug mode. This will result in a more verbose log file");
        OptionBuilder.withLongOpt((String)"debug");
        option = OptionBuilder.create((String)"d");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Update variants IDs of study data to match reference data");
        OptionBuilder.withLongOpt((String)"update-id");
        option = OptionBuilder.create((String)"id");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"boolean");
        OptionBuilder.withDescription((String)"Keep variants not present in reference data");
        OptionBuilder.withLongOpt((String)"keep");
        option = OptionBuilder.create((String)"k");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Shapeit2 does not output the sequence name in the first column of the haplotype file. Use this option to force the chromosome for all variants. This option is only valid in combination with --inputType SHAPEIT2");
        OptionBuilder.withLongOpt((String)"forceChr");
        option = OptionBuilder.create((String)"f");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"If there are not enough variants in LD and the minor allele frequency (MAF) of a variant <= the specified value in both study as in reference then the minor allele can be used as a backup for alignment. Defaults to 0.0");
        OptionBuilder.withLongOpt((String)"mafAlign");
        option = OptionBuilder.create((String)"ma");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The minimum posterior probability to call genotypes in the input data 0.4");
        OptionBuilder.withLongOpt((String)"inputProb");
        option = OptionBuilder.create((String)"ip");
        OPTIONS.addOption(option);
    }
}

