/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.animation.D2;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Bounds;
import javax.swing.ImageIcon;
import nl.tudelft.simulation.dsol.animation.D2.Renderable2D;
import nl.tudelft.simulation.dsol.animation.LocatableInterface;
import nl.tudelft.simulation.dsol.animation.StaticLocation;
import nl.tudelft.simulation.dsol.simulators.SimulatorInterface;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.BoundsUtil;
import nl.tudelft.simulation.language.d3.DirectedPoint;

public abstract class ImageRenderable
extends Renderable2D {
    private static transient Map cache = new HashMap();
    public static final short LB = -4;
    public static final short CB = -3;
    public static final short RB = -2;
    public static final short LC = -1;
    public static final short CC = 0;
    public static final short RC = 1;
    public static final short LT = 2;
    public static final short CT = 3;
    public static final short RT = 4;
    protected URL[] images = null;
    protected transient ImageIcon[] imageIcons = null;
    protected short orientation = 0;

    public ImageRenderable(LocatableInterface source, SimulatorInterface simulator, URL[] images) {
        super(source, simulator);
        this.setOrientation((short)0);
        this.readImages(images);
    }

    private void readImages(URL[] images) {
        this.images = images;
        this.imageIcons = new ImageIcon[images.length];
        for (int i = 0; i < images.length; ++i) {
            if (cache.containsKey(images[i])) {
                this.imageIcons[i] = (ImageIcon)cache.get(images[i]);
                continue;
            }
            this.imageIcons[i] = new ImageIcon(images[i]);
            cache.put(images[i], this.imageIcons[i]);
        }
    }

    public ImageRenderable(DirectedPoint staticLocation, Dimension size, SimulatorInterface simulator, URL[] images) {
        this(new StaticLocation(staticLocation, (Bounds)new BoundingBox(size.getWidth(), size.getHeight(), 0.0)), simulator, images);
    }

    public ImageRenderable(Point2D staticLocation, Dimension size, SimulatorInterface simulator, URL[] images) {
        this(new StaticLocation(new DirectedPoint(staticLocation), (Bounds)new BoundingBox(size.getWidth(), size.getHeight(), 0.0)), simulator, images);
    }

    public void paint(Graphics2D graphics, ImageObserver observer) throws RemoteException {
        int image = this.selectImage();
        if (this.imageIcons[image].getImageLoadStatus() != 8) {
            return;
        }
        Dimension size = BoundsUtil.getIntersect((DirectedPoint)this.source.getLocation(), (Bounds)this.source.getBounds(), (double)this.source.getLocation().z).getBounds().getSize();
        Point2D origin = this.resolveOrigin(this.orientation, size);
        graphics.translate(origin.getX(), origin.getY());
        graphics.scale(0.001, 0.001);
        graphics.drawImage(this.imageIcons[image].getImage(), 0, 0, (int)(1000.0 * size.getWidth()), (int)(1000.0 * size.getHeight()), observer);
        graphics.scale(1000.0, 1000.0);
        graphics.translate(-origin.getX(), -origin.getY());
    }

    public abstract int selectImage();

    public void setOrientation(short orientation) {
        this.orientation = orientation;
    }

    public ImageIcon[] getImages() {
        return this.imageIcons;
    }

    protected Point2D resolveOrigin(short orientation, Dimension size) {
        Point2D.Double imageOrigin = new Point2D.Double(0.0, 0.0);
        switch (orientation) {
            case -4: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX(), ((Point2D)imageOrigin).getY() - size.getHeight());
                return imageOrigin;
            }
            case -3: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 0.5 * size.getWidth(), ((Point2D)imageOrigin).getY() - size.getHeight());
                return imageOrigin;
            }
            case -2: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 1.0 * size.getWidth(), ((Point2D)imageOrigin).getY() - size.getHeight());
                return imageOrigin;
            }
            case -1: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX(), ((Point2D)imageOrigin).getY() - 0.5 * size.getHeight());
                return imageOrigin;
            }
            case 0: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 0.5 * size.getWidth(), ((Point2D)imageOrigin).getY() - 0.5 * size.getHeight());
                return imageOrigin;
            }
            case 1: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 1.0 * size.getWidth(), ((Point2D)imageOrigin).getY() - 0.5 * size.getHeight());
                return imageOrigin;
            }
            case 2: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX(), ((Point2D)imageOrigin).getY());
                return imageOrigin;
            }
            case 3: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 0.5 * size.getWidth(), ((Point2D)imageOrigin).getY());
                return imageOrigin;
            }
            case 4: {
                ((Point2D)imageOrigin).setLocation(((Point2D)imageOrigin).getX() - 1.0 * size.getWidth(), ((Point2D)imageOrigin).getY());
                return imageOrigin;
            }
        }
        throw new IllegalArgumentException("unknown origin location");
    }

    public short getOrientation() {
        return this.orientation;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (cache == null) {
            cache = new HashMap();
        }
        this.readImages(this.images);
    }
}

