/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.VariantLineMapper;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.vcf.VcfRecord;

public class VcfVariantLineMapper
implements VariantLineMapper {
    private final List<String> colNames;
    private final List<Annotation> infoAnnotations;
    private final Map<String, String> altDescriptions;
    private final SampleVariantsProvider sampleVariantsProvider;

    public VcfVariantLineMapper(List<String> colNames, List<Annotation> infoAnnotations, Map<String, String> altDescriptions, SampleVariantsProvider sampleVariantsProvider) {
        this.colNames = colNames;
        this.infoAnnotations = infoAnnotations;
        this.altDescriptions = altDescriptions;
        this.sampleVariantsProvider = sampleVariantsProvider;
    }

    @Override
    public GeneticVariant mapLine(String line) {
        VcfRecord record = new VcfRecord(line, this.colNames);
        List<String> ids = record.getId();
        String sequenceName = record.getChrom();
        int startPos = record.getPos();
        List<String> alleles = record.getAlleles();
        String refAllele = record.getRef();
        Map<String, Object> annotationValues = this.getAnnotationValues(record, this.infoAnnotations);
        ArrayList<String> altTypes = new ArrayList<String>();
        ArrayList<String> altDescriptions = new ArrayList<String>();
        if (alleles.size() > 0) {
            for (int i = 1; i < alleles.size(); ++i) {
                String alt = alleles.get(i);
                if (alt == null || !alt.startsWith("<") || !alt.endsWith(">")) continue;
                String altType = alt.substring(1, alt.length() - 1);
                altTypes.add(altType);
                String altDescription = this.altDescriptions.get(altType);
                if (altDescription == null) continue;
                altDescriptions.add(altDescription);
            }
        }
        GeneticVariant variant = ReadOnlyGeneticVariant.createVariant(ids, startPos, sequenceName, annotationValues, this.sampleVariantsProvider, alleles, refAllele);
        return variant;
    }

    private Map<String, Object> getAnnotationValues(VcfRecord record, List<Annotation> annotations) {
        HashMap<String, Object> annotationValues = new HashMap<String, Object>();
        for (Annotation annotation : annotations) {
            String annoId = annotation.getId();
            Object annoValue = null;
            List<String> values = record.getInfo(annotation.getId());
            if (values == null || values.isEmpty()) continue;
            switch (annotation.getType()) {
                case INTEGER: {
                    if (annotation.isList()) {
                        ArrayList<Integer> ints = new ArrayList<Integer>();
                        for (String value : values) {
                            ints.add(Integer.valueOf(value));
                        }
                        annoValue = ints;
                        break;
                    }
                    annoValue = Integer.valueOf(values.get(0));
                    break;
                }
                case BOOLEAN: {
                    if (annotation.isList()) {
                        ArrayList<Boolean> bools = new ArrayList<Boolean>();
                        for (String value : values) {
                            bools.add(Boolean.parseBoolean(value));
                        }
                        annoValue = bools;
                        break;
                    }
                    annoValue = Boolean.parseBoolean(values.get(0));
                    break;
                }
                case FLOAT: {
                    if (annotation.isList()) {
                        ArrayList<Float> floats = new ArrayList<Float>();
                        for (String value : values) {
                            floats.add(Float.valueOf(Float.parseFloat(value)));
                        }
                        annoValue = floats;
                        break;
                    }
                    annoValue = Float.valueOf(Float.parseFloat(values.get(0)));
                    break;
                }
                case CHAR: {
                    if (annotation.isList()) {
                        ArrayList<Character> chars = new ArrayList<Character>();
                        for (String value : values) {
                            chars.add(Character.valueOf(value.charAt(0)));
                        }
                        annoValue = chars;
                        break;
                    }
                    annoValue = Character.valueOf(values.get(0).charAt(0));
                    break;
                }
                default: {
                    annoValue = annotation.isList() ? values : values.get(0);
                }
            }
            if (annoValue == null) continue;
            annotationValues.put(annoId, annoValue);
        }
        return annotationValues;
    }
}

