/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.ArrayList;
import java.util.List;
import org.molgenis.genotype.vcf.VcfUtils;

public class VcfSampleGenotype {
    private List<Character> alleleIndices;
    private List<Boolean> phasing;

    public VcfSampleGenotype(List<Character> alleleIndices, List<Boolean> phasing) {
        if (alleleIndices == null) {
            throw new IllegalArgumentException("alleleIndices list is null");
        }
        if (phasing == null) {
            throw new IllegalArgumentException("Phasing list is null");
        }
        this.alleleIndices = alleleIndices;
        this.phasing = phasing;
    }

    public List<Character> getAlleleIndices() {
        return this.alleleIndices;
    }

    public int getAlleleIndexCount() {
        return this.alleleIndices.size();
    }

    public List<Boolean> getPhasing() {
        return this.phasing;
    }

    public List<String> getSamleVariants(List<String> alleles) {
        ArrayList<String> sampleVariants = new ArrayList<String>(this.alleleIndices.size());
        for (Character index : this.alleleIndices) {
            String variant = null;
            String value = VcfUtils.checkNullValue(Character.toString(index.charValue()));
            if (value != null) {
                variant = alleles.get(Integer.parseInt(value));
            }
            sampleVariants.add(variant);
        }
        return sampleVariants;
    }
}

