/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class VcfHeaderParser {
    private String rawHeader;

    public VcfHeaderParser(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Header can not be null");
        }
        if (!header.startsWith("##")) {
            throw new IllegalArgumentException("A VCF header must start with '##'");
        }
        if (!header.contains("=")) {
            throw new IllegalArgumentException("A VCF header must at least contain one '=', is key value based");
        }
        if (header.contains("<") && !header.contains(">")) {
            throw new IllegalArgumentException("Missing '>'");
        }
        if (header.contains(">") && !header.contains("<")) {
            throw new IllegalArgumentException("Missing '<'");
        }
        this.rawHeader = header;
    }

    public Tuple parse() {
        KeyValueTuple result = new KeyValueTuple();
        boolean inHeaderBlock = false;
        boolean inQuotes = false;
        boolean inKey = true;
        String key = "";
        String value = "";
        char[] arr$ = this.rawHeader.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (!inHeaderBlock) {
                if ('<' != c.charValue()) continue;
                inHeaderBlock = true;
                continue;
            }
            if (inKey && '=' == c.charValue()) {
                inKey = false;
                continue;
            }
            if (!inKey && '\"' == c.charValue()) {
                if (inQuotes) {
                    inQuotes = false;
                    result.set(key, (Object)value);
                    key = "";
                    value = "";
                    inKey = true;
                    continue;
                }
                inQuotes = true;
                continue;
            }
            if (!(inQuotes || ',' != c.charValue() && '>' != c.charValue())) {
                result.set(key, (Object)value);
                key = "";
                value = "";
                inKey = true;
                continue;
            }
            if (inKey) {
                key = key + c;
                continue;
            }
            value = value + c;
        }
        return result;
    }
}

