/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.io.IOUtils;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeDataIndex;
import org.molgenis.genotype.IndexedGenotypeData;
import org.molgenis.genotype.RawLineQueryResult;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.VcfAnnotation;
import org.molgenis.genotype.tabix.TabixFileNotFoundException;
import org.molgenis.genotype.tabix.TabixIndex;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.vcf.VcfAlt;
import org.molgenis.genotype.vcf.VcfContig;
import org.molgenis.genotype.vcf.VcfInfo;
import org.molgenis.genotype.vcf.VcfReader;
import org.molgenis.genotype.vcf.VcfRecord;
import org.molgenis.genotype.vcf.VcfSampleGenotype;
import org.molgenis.genotype.vcf.VcfVariantLineMapper;

public class VcfGenotypeData
extends IndexedGenotypeData
implements SampleVariantsProvider {
    private final GenotypeDataIndex index;
    private final VcfReader reader;
    private Map<String, Annotation> sampleAnnotationsMap;
    private Map<String, String> altDescriptions;
    private final int sampleVariantProviderUniqueId;

    public VcfGenotypeData(File bzipVcfFile) throws FileNotFoundException, IOException {
        this(bzipVcfFile, 100);
    }

    public VcfGenotypeData(File bzipVcfFile, int cacheSize) throws FileNotFoundException, IOException {
        this(bzipVcfFile, new File(bzipVcfFile.getAbsolutePath() + ".tbi"), cacheSize);
    }

    public VcfGenotypeData(File bzipVcfFile, File tabixIndexFile) throws FileNotFoundException, IOException {
        this(bzipVcfFile, tabixIndexFile, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcfGenotypeData(File vcfFile, File tabixIndexFile, int cacheSize) throws FileNotFoundException, IOException {
        if (!vcfFile.isFile()) {
            throw new FileNotFoundException("VCF file not found at " + vcfFile.getAbsolutePath());
        }
        if (!vcfFile.canRead()) {
            throw new IOException("Cannot read VCF file at: " + vcfFile.getAbsolutePath());
        }
        if (!tabixIndexFile.isFile()) {
            throw new TabixFileNotFoundException("VCF tabix file not found at " + tabixIndexFile.getAbsolutePath(), tabixIndexFile.getAbsolutePath());
        }
        if (!tabixIndexFile.canRead()) {
            throw new IOException("Cannot read tabix file for VCF at: " + tabixIndexFile.getAbsolutePath());
        }
        try {
            this.reader = new VcfReader((InputStream)new BlockCompressedInputStream(vcfFile));
            try {
                SampleVariantsProvider sampleVariantProvider = cacheSize <= 0 ? this : new CachedSampleVariantProvider(this, cacheSize);
                VcfVariantLineMapper variantLineMapper = new VcfVariantLineMapper(this.reader.getColNames(), this.getVariantAnnotations(), this.getAltDescriptions(), sampleVariantProvider);
                this.index = new TabixIndex(tabixIndexFile, vcfFile, variantLineMapper);
            }
            finally {
                IOUtils.closeQuietly((Closeable)((Object)this.reader));
            }
        }
        catch (IOException e) {
            throw new GenotypeDataException(e);
        }
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
    }

    @Override
    public List<Alleles> getSampleVariants(final GeneticVariant variant) {
        List<VcfSampleGenotype> sampleGenotypes = this.getSampleGenotypes(variant);
        return Lists.transform(sampleGenotypes, (Function)new Function<VcfSampleGenotype, Alleles>(){

            @Nullable
            public Alleles apply(@Nullable VcfSampleGenotype input) {
                if (input == null) {
                    return null;
                }
                return Alleles.createBasedOnString(input.getSamleVariants(variant.getVariantAlleles().getAllelesAsString()));
            }
        });
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        if (this.sampleAnnotationsMap == null) {
            List<VcfInfo> infos = this.reader.getInfos();
            this.sampleAnnotationsMap = new LinkedHashMap<String, Annotation>(infos.size());
            for (VcfInfo info : infos) {
                this.sampleAnnotationsMap.put(info.getId(), VcfAnnotation.fromVcfInfo(info));
            }
        }
        return this.sampleAnnotationsMap;
    }

    public List<Sequence> getSequences() {
        List<String> seqNames = this.getSeqNames();
        Map<String, Integer> seqLengths = this.getSequenceLengths();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(seqNames.size());
        for (String seqName : seqNames) {
            sequences.add(new SimpleSequence(seqName, seqLengths.get(seqName), this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        List<String> sampleNames;
        try {
            sampleNames = this.reader.getSampleNames();
        }
        catch (IOException e) {
            throw new GenotypeDataException("IOException getting samplenames from VcfReader", e);
        }
        ArrayList<Sample> samples = new ArrayList<Sample>(sampleNames.size());
        for (String sampleName : sampleNames) {
            Sample sample = new Sample(sampleName, null, null);
            samples.add(sample);
        }
        return samples;
    }

    private Map<String, Integer> getSequenceLengths() {
        List<VcfContig> contigs = this.reader.getContigs();
        HashMap<String, Integer> sequenceLengthById = new HashMap<String, Integer>(contigs.size());
        for (VcfContig contig : contigs) {
            sequenceLengthById.put(contig.getId(), contig.getLength());
        }
        return sequenceLengthById;
    }

    private Map<String, String> getAltDescriptions() {
        if (this.altDescriptions == null) {
            List<VcfAlt> alts = this.reader.getAlts();
            this.altDescriptions = new HashMap<String, String>(alts.size());
            for (VcfAlt alt : alts) {
                this.altDescriptions.put(alt.getId(), alt.getDescription());
            }
        }
        return this.altDescriptions;
    }

    @Override
    protected GenotypeDataIndex getIndex() {
        return this.index;
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        List<VcfSampleGenotype> sampleGenotypes = this.getSampleGenotypes(variant);
        return Lists.transform(sampleGenotypes, (Function)new Function<VcfSampleGenotype, Boolean>(){

            @Nullable
            public Boolean apply(VcfSampleGenotype input) {
                if (input == null) {
                    return false;
                }
                return input.getPhasing().get(0);
            }
        });
    }

    private List<VcfSampleGenotype> getSampleGenotypes(GeneticVariant variant) {
        RawLineQueryResult queryResult = this.index.createRawLineQuery().executeQuery(variant.getSequenceName(), variant.getStartPos());
        ArrayList<VcfSampleGenotype> genotypes = new ArrayList<VcfSampleGenotype>();
        try {
            for (String line : queryResult) {
                List<String> alleles = variant.getVariantAlleles().getAllelesAsString();
                VcfRecord record = new VcfRecord(line, this.reader.getColNames());
                if (!record.getChrom().equalsIgnoreCase(variant.getSequenceName()) || record.getPos().intValue() != variant.getStartPos() || !((Object)record.getAlleles()).equals(alleles)) continue;
                List<String> sampleNames = this.reader.getSampleNames();
                for (String sampleName : sampleNames) {
                    VcfSampleGenotype geno = record.getSampleGenotype(sampleName);
                    if (geno == null) {
                        throw new GenotypeDataException("Missing GT format value for sample [" + sampleName + "]");
                    }
                    genotypes.add(geno);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)queryResult);
        }
        return genotypes;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return false;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertDosageToProbabilityHeuristic(variant.getSampleDosages());
    }
}

