/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variant;

import java.util.List;
import java.util.Map;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public interface GeneticVariant
extends Comparable<GeneticVariant> {
    public String getPrimaryVariantId();

    public List<String> getAlternativeVariantIds();

    public List<String> getAllIds();

    public GeneticVariantId getVariantId();

    public int getStartPos();

    public String getSequenceName();

    public Alleles getVariantAlleles();

    public int getAlleleCount();

    public Allele getRefAllele();

    public List<Alleles> getSampleVariants();

    public Map<String, ?> getAnnotationValues();

    public double getMinorAlleleFrequency();

    public Allele getMinorAllele();

    public boolean isSnp();

    public boolean isAtOrGcSnp();

    public Ld calculateLd(GeneticVariant var1) throws LdCalculatorException;

    public boolean isBiallelic();

    public float[] getSampleDosages();

    public byte[] getSampleCalledDosages();

    public List<Boolean> getSamplePhasing();

    public SampleVariantsProvider getSampleVariantsProvider();

    public boolean isMapped();

    public double getCallRate();

    public double getHwePvalue();

    public float[][] getSampleGenotypeProbilities();
}

