/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;

public class ProbabilitiesConvertor {
    public static float[][] convertCalledAllelesToProbability(List<Alleles> sampleAlleles, Alleles alleles) {
        Alleles BB;
        Alleles BA;
        Alleles AB;
        float[][] probs = new float[sampleAlleles.size()][3];
        if (alleles.getAlleleCount() == 0) {
            throw new GenotypeDataException("Error converting alleles to probabilities. No alleles detected");
        }
        if (alleles.getAlleleCount() > 2) {
            Arrays.fill((Object[])probs, new float[]{0.0f, 0.0f, 0.0f});
            return probs;
        }
        Alleles AA = Alleles.createAlleles(alleles.get(0), alleles.get(0));
        if (alleles.getAlleleCount() == 2) {
            AB = Alleles.createAlleles(alleles.get(0), alleles.get(1));
            BA = Alleles.createAlleles(alleles.get(1), alleles.get(0));
            BB = Alleles.createAlleles(alleles.get(1), alleles.get(1));
        } else {
            AB = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
            BA = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
            BB = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
        }
        for (int i = 0; i < probs.length; ++i) {
            Alleles sampleVariant = sampleAlleles.get(i);
            probs[i] = sampleVariant.contains(Allele.ZERO) ? new float[]{0.0f, 0.0f, 0.0f} : (sampleVariant == AA ? new float[]{1.0f, 0.0f, 0.0f} : (sampleVariant == AB ? new float[]{0.0f, 1.0f, 0.0f} : (sampleVariant == BA ? new float[]{0.0f, 1.0f, 0.0f} : (sampleVariant == BB ? new float[]{0.0f, 0.0f, 1.0f} : new float[]{0.0f, 0.0f, 0.0f}))));
        }
        return probs;
    }

    public static float[][] convertDosageToProbabilityHeuristic(float[] sampleDosages) {
        float[][] probs = new float[sampleDosages.length][3];
        for (int i = 0; i < sampleDosages.length; ++i) {
            float sampleDosage = sampleDosages[i];
            probs[i] = sampleDosage > 2.0f || sampleDosage < 0.0f ? new float[]{0.0f, 0.0f, 0.0f} : (sampleDosage < 1.0f ? new float[]{0.0f, sampleDosage, 1.0f - sampleDosage} : new float[]{sampleDosage - 1.0f, 2.0f - sampleDosage, 0.0f});
        }
        return probs;
    }

    public static List<Alleles> convertProbabilitiesToAlleles(float[][] probs, Alleles variantAlleles, double minProbability) {
        ArrayList<Alleles> sampleAlleles = new ArrayList<Alleles>(probs.length);
        int alleleCount = variantAlleles.getAlleleCount();
        if (alleleCount > 2 || alleleCount == 0) {
            throw new GenotypeDataException("Error converting posterior probabilities to called alleles. Found non biallelic SNP");
        }
        Alleles aa = Alleles.createAlleles(variantAlleles.get(0), variantAlleles.get(0));
        Alleles bb = alleleCount == 2 ? Alleles.createAlleles(variantAlleles.get(1), variantAlleles.get(1)) : null;
        Alleles missing = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
        block6: for (float[] sampleProbs : probs) {
            int maxProbIndex = -1;
            float maxProb = 0.0f;
            int i = 0;
            for (float prob : sampleProbs) {
                if (prob > 0.0f && (double)prob >= minProbability && prob > maxProb) {
                    maxProbIndex = i;
                    maxProb = prob;
                }
                ++i;
            }
            if (alleleCount == 1 && maxProbIndex >= 1) {
                throw new GenotypeDataException("Error converting posterior probabilities to called alleles. Illigale probability.");
            }
            switch (maxProbIndex) {
                case -1: {
                    sampleAlleles.add(missing);
                    continue block6;
                }
                case 0: {
                    sampleAlleles.add(aa);
                    continue block6;
                }
                case 1: {
                    sampleAlleles.add(variantAlleles);
                    continue block6;
                }
                case 2: {
                    sampleAlleles.add(bb);
                    continue block6;
                }
                default: {
                    throw new GenotypeDataException("Error converting posterior probabilities to called alleles. This should not happen, please report this bug.");
                }
            }
        }
        return sampleAlleles;
    }

    public static float[] convertProbabilitiesToDosage(float[][] probs, double minProbability) {
        float[] dosages = new float[probs.length];
        for (int i = 0; i < probs.length; ++i) {
            boolean containsMinProbability = false;
            for (float prob : probs[i]) {
                if (!((double)prob >= minProbability)) continue;
                containsMinProbability = true;
                break;
            }
            if (containsMinProbability) {
                dosages[i] = probs[i][0] * 2.0f + probs[i][1];
                if (!(dosages[i] > 2.0f)) continue;
                dosages[i] = 2.0f;
                continue;
            }
            dosages[i] = -1.0f;
        }
        return dosages;
    }
}

