/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.tabix;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.molgenis.genotype.GenotypeDataIndex;
import org.molgenis.genotype.RawLineQuery;
import org.molgenis.genotype.VariantQuery;
import org.molgenis.genotype.tabix.TabixQuery;
import org.molgenis.genotype.tabix.TabixRawLineQuery;
import org.molgenis.genotype.variant.VariantLineMapper;

@SuppressWarnings(value={"RR_NOT_CHECKED"})
public class TabixIndex
implements GenotypeDataIndex {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static int MAX_BIN = 37450;
    private static int TAD_LIDX_SHIFT = 14;
    private String[] seqNames;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private TIndex[] mIndex;
    private HashMap<String, Integer> mChr2tid;
    private File bzipFile;
    private VariantLineMapper variantLineMapper;

    public TabixIndex(File tabixIndexFile, File bzipFile, VariantLineMapper variantLineMapper) throws IOException {
        this.bzipFile = bzipFile;
        this.variantLineMapper = variantLineMapper;
        this.readIndexFile(tabixIndexFile);
    }

    @Override
    public List<String> getSeqNames() {
        return Collections.unmodifiableList(Arrays.asList(this.seqNames));
    }

    public TIndex[] getIndex() {
        return (TIndex[])this.mIndex.clone();
    }

    @Override
    public VariantQuery createQuery() {
        return new TabixQuery(this.bzipFile, this, this.variantLineMapper);
    }

    @Override
    public RawLineQuery createRawLineQuery() {
        return new TabixRawLineQuery(this.bzipFile, this);
    }

    private int chr2tid(String chr) {
        if (this.mChr2tid.containsKey(chr)) {
            return this.mChr2tid.get(chr);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile(File tabixIndexFile) throws IOException {
        BlockCompressedInputStream bciStream = new BlockCompressedInputStream(tabixIndexFile);
        try {
            int i;
            byte[] buf = new byte[4];
            bciStream.read(buf, 0, 4);
            this.seqNames = new String[this.readInt((InputStream)bciStream)];
            this.mChr2tid = new HashMap();
            this.mPreset = this.readInt((InputStream)bciStream);
            this.mSc = this.readInt((InputStream)bciStream);
            this.mBc = this.readInt((InputStream)bciStream);
            this.mEc = this.readInt((InputStream)bciStream);
            this.mMeta = this.readInt((InputStream)bciStream);
            this.readInt((InputStream)bciStream);
            int l = this.readInt((InputStream)bciStream);
            buf = new byte[l];
            bciStream.read(buf);
            int k = 0;
            int j = 0;
            for (i = 0; i < buf.length; ++i) {
                if (buf[i] != 0) continue;
                byte[] b = new byte[i - j];
                System.arraycopy(buf, j, b, 0, b.length);
                String s = new String(b, CHARSET_UTF8);
                this.mChr2tid.put(s, k);
                this.seqNames[k++] = s;
                j = i + 1;
            }
            this.mIndex = new TIndex[this.seqNames.length];
            for (i = 0; i < this.seqNames.length; ++i) {
                int n_bin = this.readInt((InputStream)bciStream);
                this.mIndex[i] = new TIndex();
                this.mIndex[i].b = new HashMap();
                for (j = 0; j < n_bin; ++j) {
                    int bin = this.readInt((InputStream)bciStream);
                    TPair64[] chunks = new TPair64[this.readInt((InputStream)bciStream)];
                    for (k = 0; k < chunks.length; ++k) {
                        long u = this.readLong((InputStream)bciStream);
                        long v = this.readLong((InputStream)bciStream);
                        chunks[k] = new TPair64(u, v);
                    }
                    this.mIndex[i].b.put(bin, chunks);
                }
                this.mIndex[i].l = new long[this.readInt((InputStream)bciStream)];
                for (k = 0; k < this.mIndex[i].l.length; ++k) {
                    this.mIndex[i].l[k] = this.readLong((InputStream)bciStream);
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)bciStream);
        }
    }

    private int readInt(InputStream in) throws IOException {
        byte[] buf = new byte[4];
        in.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private long readLong(InputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    private int reg2bins(int beg, int _end, int[] list) {
        int i = 0;
        int end = _end;
        if (beg >= end) {
            return 0;
        }
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list[i++] = 0;
        int k = 1 + (beg >> 26);
        while (k <= 1 + (end >> 26)) {
            list[i++] = k++;
        }
        k = 9 + (beg >> 23);
        while (k <= 9 + (end >> 23)) {
            list[i++] = k++;
        }
        k = 73 + (beg >> 20);
        while (k <= 73 + (end >> 20)) {
            list[i++] = k++;
        }
        k = 585 + (beg >> 17);
        while (k <= 585 + (end >> 17)) {
            list[i++] = k++;
        }
        k = 4681 + (beg >> 14);
        while (k <= 4681 + (end >> 14)) {
            list[i++] = k++;
        }
        return i;
    }

    protected TabixIterator queryTabixIndex(String sequence, int beg, int end, BlockCompressedInputStream bzipInputStream) throws IOException {
        TPair64[] chunks;
        int i;
        int tid = this.chr2tid(sequence);
        if (tid == -1) {
            return null;
        }
        TIndex idx = this.mIndex[tid];
        int[] bins = new int[MAX_BIN];
        int n_bins = this.reg2bins(beg, end, bins);
        long min_off = idx.l.length > 0 ? (beg >> TAD_LIDX_SHIFT >= idx.l.length ? idx.l[idx.l.length - 1] : idx.l[beg >> TAD_LIDX_SHIFT]) : 0L;
        int n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            n_off += chunks.length;
        }
        if (n_off == 0) {
            return null;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            for (int j = 0; j < chunks.length; ++j) {
                if (!TabixIndex.less64(min_off, chunks[j].v)) continue;
                off[n_off++] = new TPair64(chunks[j]);
            }
        }
        if (n_off == 0) {
            return null;
        }
        Arrays.sort(off, 0, n_off);
        int l = 0;
        for (i = 1; i < n_off; ++i) {
            if (!TabixIndex.less64(((TPair64)off[l]).v, ((TPair64)off[i]).v)) continue;
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        for (i = 1; i < n_off; ++i) {
            if (TabixIndex.less64(((TPair64)off[i - 1]).v, ((TPair64)off[i]).u)) continue;
            ((TPair64)off[i - 1]).v = ((TPair64)off[i]).u;
        }
        l = 0;
        for (i = 1; i < n_off; ++i) {
            if (((TPair64)off[l]).v >> 16 == ((TPair64)off[i]).u >> 16) {
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
                continue;
            }
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        TPair64[] ret = new TPair64[n_off];
        for (i = 0; i < n_off; ++i) {
            ret[i] = new TPair64(((TPair64)off[i]).u, ((TPair64)off[i]).v);
        }
        return new TabixIterator(tid, beg, end, ret, bzipInputStream);
    }

    private static class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    protected class TabixIterator {
        private int i = -1;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;
        private BlockCompressedInputStream inputStream;

        public TabixIterator(int _tid, int _beg, int _end, TPair64[] _off, BlockCompressedInputStream inputStream) {
            this.off = (TPair64[])_off.clone();
            this.tid = _tid;
            this.beg = _beg;
            this.end = _end;
            this.inputStream = inputStream;
        }

        public String next() throws IOException {
            block5: {
                String s;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixIndex.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            this.inputStream.seek(this.off[this.i + 1].u);
                            this.curr_off = this.inputStream.getFilePointer();
                        }
                        ++this.i;
                    }
                    if ((s = this.inputStream.readLine()) == null) break block5;
                    char[] str = s.toCharArray();
                    this.curr_off = this.inputStream.getFilePointer();
                    if (str.length == 0 || str[0] == TabixIndex.this.mMeta) continue;
                    TIntv intv = this.getIntv(s);
                    if (intv.tid != this.tid || intv.beg >= this.end) break block5;
                    if (intv.end > this.beg && intv.beg < this.end) break;
                }
                return s;
            }
            this.iseof = true;
            return null;
        }

        private TIntv getIntv(String s) {
            TIntv intv = new TIntv();
            int col = 0;
            int end = 0;
            int beg = 0;
            while ((end = s.indexOf(9, beg)) >= 0 || end == -1) {
                if (++col == TabixIndex.this.mSc) {
                    intv.tid = TabixIndex.this.chr2tid(s.substring(beg, end));
                } else if (col == TabixIndex.this.mBc) {
                    intv.end = Integer.parseInt(s.substring(beg, end == -1 ? s.length() : end));
                    intv.beg = intv.end++;
                    if ((TabixIndex.this.mPreset & 0x10000) == 0) {
                        --intv.beg;
                    }
                    if (intv.beg < 0) {
                        intv.beg = 0;
                    }
                    if (intv.end < 1) {
                        intv.end = 1;
                    }
                } else if ((TabixIndex.this.mPreset & 0xFFFF) == 0) {
                    if (col == TabixIndex.this.mEc) {
                        intv.end = Integer.parseInt(s.substring(beg, end));
                    }
                } else if ((TabixIndex.this.mPreset & 0xFFFF) == 1) {
                    if (col == 6) {
                        int l = 0;
                        String cigar = s.substring(beg, end);
                        int j = 0;
                        for (int i = 0; i < cigar.length(); ++i) {
                            char op;
                            if (cigar.charAt(i) <= '9' || (op = cigar.charAt(i)) != 'M' && op != 'D' && op != 'N') continue;
                            l += Integer.parseInt(cigar.substring(j, i));
                        }
                        intv.end = intv.beg + l;
                    }
                } else if ((TabixIndex.this.mPreset & 0xFFFF) == 2) {
                    String alt;
                    String string = alt = end >= 0 ? s.substring(beg, end) : s.substring(beg);
                    if (col == 4) {
                        if (alt.length() > 0) {
                            intv.end = intv.beg + alt.length();
                        }
                    } else if (col == 8) {
                        int e_off = -1;
                        int i = alt.indexOf("END=");
                        if (i == 0) {
                            e_off = 4;
                        } else if (i > 0 && (i = alt.indexOf(";END=")) >= 0) {
                            e_off = i + 5;
                        }
                        if (e_off > 0) {
                            i = alt.indexOf(";", e_off);
                            intv.end = Integer.parseInt(i > e_off ? alt.substring(e_off, i) : alt.substring(e_off));
                        }
                    }
                }
                if (end == -1) break;
                beg = end + 1;
            }
            return intv;
        }
    }

    private static class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        private TIndex() {
        }
    }

    private static class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TPair64)) {
                return false;
            }
            return this.compareTo((TPair64)obj) == 0;
        }

        public int hashCode() {
            return new HashCodeBuilder(3, 17).append(this.u).append(this.v).toHashCode();
        }
    }
}

