/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.sampleFilter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.sampleFilter.ConvertToSampleFilterIterable;
import org.molgenis.genotype.sampleFilter.SampleFilter;
import org.molgenis.genotype.sampleFilter.SampleFilterableGenotypeData;
import org.molgenis.genotype.sampleFilter.SampleFilteredReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.GeneticVariant;

public class SampleFilterableGenotypeDataDecorator
extends AbstractRandomAccessGenotypeData
implements SampleFilterableGenotypeData {
    private final RandomAccessGenotypeData original;
    private final ArrayList<Sample> includedSamples;
    private final SampleFilter sampleFilter;

    public SampleFilterableGenotypeDataDecorator(RandomAccessGenotypeData original, SampleFilter sampleFilter) {
        this.original = original;
        this.sampleFilter = sampleFilter;
        this.includedSamples = new ArrayList();
        for (Sample sample : original.getSamples()) {
            if (!sampleFilter.doesSamplePassFilter(sample)) continue;
            this.includedSamples.add(sample);
        }
    }

    @Override
    public List<String> getSeqNames() {
        return this.original.getSeqNames();
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.original.getSequences();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.original.getSequenceByName(name);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return new ConvertToSampleFilterIterable(this.original.getVariantsByPos(seqName, startPos), this);
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        GeneticVariant variant = this.original.getSnpVariantByPos(seqName, startPos);
        return variant == null ? null : new SampleFilteredReadOnlyGeneticVariant(variant, this);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return new ConvertToSampleFilterIterable(this.original.getSequenceGeneticVariants(seqName), this);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return new ConvertToSampleFilterIterable(this.original.getVariantsByRange(seqName, rangeStart, rangeEnd), this);
    }

    @Override
    public List<Annotation> getVariantAnnotations() {
        return this.original.getVariantAnnotations();
    }

    @Override
    public Annotation getVariantAnnotation(String annotationId) {
        return this.original.getVariantAnnotation(annotationId);
    }

    @Override
    public List<SampleAnnotation> getSampleAnnotations() {
        return this.original.getSampleAnnotations();
    }

    @Override
    public Annotation getSampleAnnotation(String annotationId) {
        return this.original.getSampleAnnotation(annotationId);
    }

    @Override
    public List<Sample> getSamples() {
        return this.includedSamples;
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return new ConvertToSampleFilterIterable(this.original, this).iterator();
    }

    @Override
    public int getIncludedSampleCount() {
        return this.includedSamples.size();
    }

    @Override
    public List<Sample> getOriginalSampleList() {
        return this.original.getSamples();
    }

    @Override
    public SampleFilter getSampleFilter() {
        return this.sampleFilter;
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.original.getSampleAnnotationsMap();
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return this.original.getVariantAnnotationsMap();
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return this.original.isOnlyContaingSaveProbabilityGenotypes();
    }
}

