/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.NotASnpException;

public class BedBimFamGenotypeWriter
implements GenotypeWriter {
    private static final byte MAGIC_NUMBER_1 = 108;
    private static final byte MAGIC_NUMBER_2 = 27;
    private static final byte MODE = 1;
    private static final int HOMOZYGOTE_SECOND_BITMASK = 192;
    private static final int HETEROZYGOTE_BITMASK = 128;
    private static final int MISSING_BIT_MASK = 64;
    private static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    private static final char SEPARATOR = ' ';
    private static final DecimalFormat PHENO_FORMATTER = new DecimalFormat("0.#####");
    private final GenotypeData genotypeData;
    private int writtenSamplesCounter;
    private int writtenVariantsCounter;
    private int excludedVariantsCounter;
    private static final Logger LOGGER = Logger.getLogger(BedBimFamGenotypeWriter.class);

    public BedBimFamGenotypeWriter(GenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    @Override
    public void write(String path) throws IOException, NotASnpException {
        this.write(new File(path + ".bed"), new File(path + ".bim"), new File(path + ".fam"));
    }

    public void write(File bedFile, File bimFile, File famFile) throws IOException {
        if (bedFile == null) {
            throw new IllegalArgumentException("No bed file specified to write to");
        }
        if (bimFile == null) {
            throw new IllegalArgumentException("No bim file specified to write to");
        }
        if (famFile == null) {
            throw new IllegalArgumentException("No fam file specified to write to");
        }
        this.writtenSamplesCounter = 0;
        this.writtenVariantsCounter = 0;
        this.excludedVariantsCounter = 0;
        this.writeBimFile(bimFile);
        this.writeFamFile(famFile);
        this.writeBedFile(bedFile);
        LOGGER.info((Object)("Binary plink data write completed.\n - Number of samples: " + this.writtenSamplesCounter + "\n" + " - Number of SNPs: " + this.writtenVariantsCounter + "\n" + " - Excluded non biallelic SNPs: " + this.excludedVariantsCounter));
    }

    private void writeBimFile(File bimFile) throws IOException {
        Utils.createEmptyFile(bimFile, "bim");
        BufferedWriter bimFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(bimFile), FILE_ENCODING));
        for (GeneticVariant variant : this.genotypeData) {
            if (variant.getAlleleCount() > 2 || !variant.isSnp()) {
                LOGGER.warn((Object)("Skipping variant: " + variant.getPrimaryVariantId() + ", it is not a biallelic SNP"));
                ++this.excludedVariantsCounter;
                continue;
            }
            bimFileWriter.append(variant.getSequenceName());
            bimFileWriter.append(' ');
            bimFileWriter.append(variant.getPrimaryVariantId() == null ? variant.getSequenceName() + ":" + variant.getStartPos() : variant.getPrimaryVariantId());
            bimFileWriter.append(' ');
            bimFileWriter.append('0');
            bimFileWriter.append(' ');
            bimFileWriter.append(String.valueOf(variant.getStartPos()));
            bimFileWriter.append(' ');
            bimFileWriter.append(variant.getVariantAlleles().get(0).toString());
            bimFileWriter.append(' ');
            bimFileWriter.append(variant.getAlleleCount() == 1 ? Allele.ZERO.toString() : variant.getVariantAlleles().get(1).toString());
            bimFileWriter.append('\n');
            ++this.writtenVariantsCounter;
        }
        bimFileWriter.close();
    }

    private void writeFamFile(File famFile) throws IOException {
        Utils.createEmptyFile(famFile, "fam");
        BufferedWriter famFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(famFile), FILE_ENCODING));
        for (Sample sample : this.genotypeData.getSamples()) {
            famFileWriter.append(sample.getFamilyId() != null ? sample.getFamilyId() : "0");
            famFileWriter.append(' ');
            famFileWriter.append(sample.getId());
            famFileWriter.append(' ');
            famFileWriter.append(sample.getFatherId());
            famFileWriter.append(' ');
            famFileWriter.append(sample.getMotherId());
            famFileWriter.append(' ');
            famFileWriter.append(Byte.toString(sample.getSex().getPlinkSex()));
            famFileWriter.append(' ');
            famFileWriter.append(PHENO_FORMATTER.format(this.getPhenotype(sample)));
            famFileWriter.append('\n');
            ++this.writtenSamplesCounter;
        }
        famFileWriter.close();
    }

    private void writeBedFile(File bedFile) throws IOException {
        DataOutputStream bedStreamWriter;
        Utils.createEmptyFile(bedFile, "bed");
        try {
            bedStreamWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(bedFile)));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("This should never happen. File will be present at this time", ex);
        }
        bedStreamWriter.writeByte(108);
        bedStreamWriter.writeByte(27);
        bedStreamWriter.writeByte(1);
        for (GeneticVariant variant : this.genotypeData) {
            if (variant.getAlleleCount() > 2 || !variant.isSnp()) continue;
            Alleles variantAlleles = variant.getVariantAlleles();
            Alleles homozygoteFirst = Alleles.createAlleles(variantAlleles.get(0), variantAlleles.get(0));
            Alleles homozygoteSecond = null;
            if (variantAlleles.getAlleleCount() == 2) {
                homozygoteSecond = Alleles.createAlleles(variantAlleles.get(1), variantAlleles.get(1));
            }
            int currentByte = 0;
            int counterCurrentByte = 0;
            for (Alleles alleles : variant.getSampleVariants()) {
                if (alleles != homozygoteFirst) {
                    if (variantAlleles.getAlleleCount() == 2 && alleles.sameAlleles(variantAlleles)) {
                        currentByte |= 0x80;
                    } else if (variantAlleles.getAlleleCount() == 2 && alleles == homozygoteSecond) {
                        currentByte |= 0xC0;
                    } else if (alleles.contains(Allele.ZERO)) {
                        currentByte |= 0x40;
                    } else {
                        throw new GenotypeDataException("Trying to write alleles " + alleles.getAllelesAsString() + " for " + variantAlleles + " SNP");
                    }
                }
                if ((counterCurrentByte = (int)((byte)(counterCurrentByte + 1))) == 4) {
                    bedStreamWriter.writeByte(currentByte);
                    currentByte = 0;
                    counterCurrentByte = 0;
                    continue;
                }
                currentByte >>>= 2;
            }
            if (counterCurrentByte == 0) continue;
            while (counterCurrentByte < 3) {
                counterCurrentByte = (byte)(counterCurrentByte + 1);
                currentByte >>>= 2;
            }
            bedStreamWriter.writeByte(currentByte);
        }
        bedStreamWriter.close();
    }

    private double getPhenotype(Sample sample) {
        Object value = sample.getAnnotationValues().get("phenotype");
        if (value == null) {
            return -9.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Double.valueOf(value.toString());
    }
}

