/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.annotation;

import org.apache.commons.lang3.math.NumberUtils;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.vcf.VcfInfo;

public class VcfAnnotation
extends Annotation {
    public static final int NUMBER_UNKNOWN = -1;
    private final Integer number;
    boolean unbounded;
    private final boolean perAltAllele;
    private final boolean perGenotype;

    public static VcfAnnotation fromVcfInfo(VcfInfo info) {
        Annotation.Type type = VcfAnnotation.toAnnotationType(info.getType());
        Integer number = null;
        boolean unbounded = false;
        boolean perAltAllele = false;
        boolean perGenotype = false;
        if (info.getNumber() != null) {
            if (info.getNumber().equalsIgnoreCase("A")) {
                perAltAllele = true;
            } else if (info.getNumber().equalsIgnoreCase("G")) {
                perGenotype = true;
            } else if (info.getNumber().equals(".")) {
                unbounded = true;
            } else if (NumberUtils.isDigits((String)info.getNumber())) {
                number = Integer.parseInt(info.getNumber());
            }
        }
        return new VcfAnnotation(info.getId(), info.getDescription(), type, number, unbounded, perAltAllele, perGenotype);
    }

    public VcfAnnotation(String id, String description, Annotation.Type type, Integer number, boolean unbounded, boolean perAltAllele, boolean perGenotype) {
        super(id, id, description, type);
        this.number = number;
        this.perAltAllele = perAltAllele;
        this.perGenotype = perGenotype;
        this.unbounded = unbounded;
    }

    public Integer getNumber() {
        return this.number;
    }

    public boolean isPerAltAllele() {
        return this.perAltAllele;
    }

    public boolean isPerGenotype() {
        return this.perGenotype;
    }

    public boolean isUnbounded() {
        return this.unbounded;
    }

    @Override
    public boolean isList() {
        return this.number != null && this.number > 1 || this.perAltAllele || this.perGenotype || this.unbounded;
    }

    private static Annotation.Type toAnnotationType(VcfInfo.Type infoType) {
        if (infoType == VcfInfo.Type.CHARACTER) {
            return Annotation.Type.CHAR;
        }
        if (infoType == VcfInfo.Type.STRING) {
            return Annotation.Type.STRING;
        }
        if (infoType == VcfInfo.Type.FLAG) {
            return Annotation.Type.BOOLEAN;
        }
        if (infoType == VcfInfo.Type.FLOAT) {
            return Annotation.Type.FLOAT;
        }
        if (infoType == VcfInfo.Type.INTEGER) {
            return Annotation.Type.INTEGER;
        }
        return Annotation.Type.UNKOWN;
    }
}

