/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.annotation;

public enum CaseControlAnnotation {
    CASE(2),
    CONTROL(1),
    UNKNOWN(0);

    private final byte plinkCase;

    private CaseControlAnnotation(byte plinkCase) {
        this.plinkCase = plinkCase;
    }

    public byte getPlinkCase() {
        return this.plinkCase;
    }

    public static CaseControlAnnotation getCaseAnnotationForPlink(byte plinkCase) {
        switch (plinkCase) {
            case 1: {
                return CONTROL;
            }
            case 2: {
                return CASE;
            }
        }
        return UNKNOWN;
    }

    public static CaseControlAnnotation getCaseAnnotationForTriTyper(String ttCase) {
        if (ttCase == null) {
            return UNKNOWN;
        }
        if (ttCase.toLowerCase().equals("control")) {
            return CONTROL;
        }
        if (ttCase.toLowerCase().equals("case")) {
            return CASE;
        }
        return UNKNOWN;
    }
}

