/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.methylation;

public class ConvertBetaToMvalue {
    public static void transToMvalue(double[][] rawData) {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int probeCount = rawData.length;
        int sampleCount = rawData[probeCount - 1].length;
        for (int p = 0; p < probeCount; ++p) {
            for (int s = 0; s < sampleCount; ++s) {
                if (rawData[p][s] != 0.0 && rawData[p][s] < minValue) {
                    minValue = rawData[p][s];
                }
                if (rawData[p][s] == 1.0 || !(rawData[p][s] > maxValue)) continue;
                maxValue = rawData[p][s];
            }
        }
        double multiplier = 1.0 / Math.log10(2.0);
        minValue = Math.log10(minValue / (1.0 - minValue)) * multiplier;
        maxValue = Math.log10(maxValue / (1.0 - maxValue)) * multiplier;
        for (int p = 0; p < probeCount; ++p) {
            for (int s = 0; s < sampleCount; ++s) {
                rawData[p][s] = rawData[p][s] == 0.0 ? minValue : (rawData[p][s] == 1.0 ? maxValue : Math.log10(rawData[p][s] / (1.0 - rawData[p][s])) * multiplier);
            }
        }
    }
}

