/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import JSci.maths.ArrayMath;
import java.util.Arrays;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.util.RankArray;

public class QuantileNormalization {
    public static void quantilenormalize(double[][] rawData) {
        System.out.println("\nPerforming quantile normalization:");
        SpearmansCorrelation spearman = new SpearmansCorrelation();
        int probeCount = rawData.length;
        int sampleCount = rawData[probeCount - 1].length;
        double[] rankedMean = new double[probeCount];
        for (int sampleID = 0; sampleID < sampleCount; ++sampleID) {
            int probeID;
            double[] x = new double[probeCount];
            for (probeID = 0; probeID < probeCount; ++probeID) {
                x[probeID] = rawData[probeID][sampleID];
            }
            Arrays.sort(x);
            for (probeID = 0; probeID < probeCount; ++probeID) {
                int n = probeID;
                rankedMean[n] = rankedMean[n] + x[probeID];
            }
        }
        int probeID = 0;
        while (probeID < probeCount) {
            int n = probeID++;
            rankedMean[n] = rankedMean[n] / (double)sampleCount;
        }
        RankArray rda = new RankArray();
        for (int s = 0; s < sampleCount; ++s) {
            int p;
            double[] probes = new double[probeCount];
            for (int p2 = 0; p2 < probeCount; ++p2) {
                probes[p2] = rawData[p2][s];
            }
            double[] probesRanked = rda.rank(probes, false);
            double[] probesQuantileNormalized = new double[probeCount];
            for (p = 0; p < probeCount; ++p) {
                probesQuantileNormalized[p] = rankedMean[(int)probesRanked[p]];
            }
            for (p = 0; p < probeCount; ++p) {
                rawData[p][s] = probesQuantileNormalized[p];
            }
            double[] probesRankedAfterQQNorm = rda.rank(probesQuantileNormalized, false);
            System.out.println("Normalized sample:\t" + (s + 1) + "\tCorrelation original data and ranked data:\t" + ArrayMath.correlation((double[])probes, (double[])probesRanked) + "\tCorrelation original data and quantile normalized data:\t" + ArrayMath.correlation((double[])probes, (double[])probesQuantileNormalized) + "\tSpearman: " + spearman.correlation(probes, probesQuantileNormalized));
        }
    }

    public static void QuantileNormAdressingNaValuesBeforeQN(double[][] rawData, boolean useMedian, boolean retainNA) {
        int s;
        boolean[][] wasNA = new boolean[rawData.length][rawData[1].length];
        for (s = 0; s < rawData[1].length; ++s) {
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            boolean needsReplacement = false;
            for (int p = 0; p < rawData.length; ++p) {
                if (rawData[p][s] == -999.0) {
                    needsReplacement = true;
                    wasNA[p][s] = true;
                    continue;
                }
                wasNA[p][s] = false;
                nonNAvalues.add(rawData[p][s]);
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int p = 0; p < rawData.length; ++p) {
                if (!wasNA[p][s]) continue;
                rawData[p][s] = replacementValue;
            }
        }
        QuantileNormalization.quantilenormalize(rawData);
        if (retainNA) {
            for (s = 0; s < rawData[1].length; ++s) {
                for (int p = 0; p < rawData.length; ++p) {
                    if (!wasNA[p][s]) continue;
                    rawData[p][s] = -999.0;
                }
            }
        }
    }

    public static void QuantileNormAdressingNaValuesAfterInitialQN(DoubleMatrixDataset<String, String> dataset, boolean retainNA, boolean useRow) {
        int s;
        double[][] dataSorted = new double[dataset.nrRows][dataset.nrCols];
        System.out.println("Quantile normalization round 1");
        for (int s2 = 0; s2 < dataset.nrCols; ++s2) {
            int p;
            ArrayIntList naValueIndeces = new ArrayIntList();
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            double[] vals = new double[dataset.nrRows];
            for (p = 0; p < dataset.nrRows; ++p) {
                if (!Double.isNaN(dataset.rawData[p][s2])) {
                    nonNAvalues.add(dataset.rawData[p][s2]);
                    vals[p] = dataset.rawData[p][s2];
                    continue;
                }
                naValueIndeces.add(p);
            }
            if (naValueIndeces.size() > 0) {
                double meanPerSample = ArrayMath.median((double[])nonNAvalues.toArray(new double[0]));
                for (int p2 : naValueIndeces.toArray()) {
                    vals[p2] = meanPerSample;
                }
            }
            Arrays.sort(vals);
            for (p = 0; p < dataset.nrRows; ++p) {
                dataSorted[p][s2] = vals[p];
            }
        }
        double[] dist = new double[dataset.nrRows];
        for (int p = 0; p < dataset.nrRows; ++p) {
            dist[p] = ArrayMath.median((double[])dataSorted[p]);
        }
        dataSorted = null;
        SpearmansCorrelation spearman = new SpearmansCorrelation();
        for (s = 0; s < dataset.nrCols; ++s) {
            ArrayDoubleList vec1 = new ArrayDoubleList();
            for (int p = 0; p < dataset.nrRows; ++p) {
                if (Double.isNaN(dataset.rawData[p][s])) continue;
                vec1.add(dataset.rawData[p][s]);
            }
            double[] vals1 = new double[vec1.size()];
            RankArray rda = new RankArray();
            double[] valsRanked = rda.rank(vec1.toArray(new double[0]), false);
            for (int v = 0; v < vals1.length; ++v) {
                double quantile = valsRanked[v] / (double)vals1.length;
                int distIndex = (int)(quantile * (double)dataset.nrRows - 1.0);
                vals1[v] = dist[distIndex + 1];
            }
            System.out.println("Normalized sample:\t" + (String)dataset.colObjects.get(s) + "\t" + s + "\tCorrelation original data and ranked data:\t" + ArrayMath.correlation((double[])vec1.toArray(new double[0]), (double[])valsRanked) + "\tCorrelation original data and quantile normalized data:\t" + ArrayMath.correlation((double[])vec1.toArray(new double[0]), (double[])vals1) + "\t" + spearman.correlation(vec1.toArray(new double[0]), vals1));
            int itr = 0;
            for (int p = 0; p < dataset.nrRows; ++p) {
                if (Double.isNaN(dataset.rawData[p][s])) continue;
                dataset.rawData[p][s] = vals1[itr];
                ++itr;
            }
        }
        if (!retainNA) {
            if (useRow) {
                for (int p = 0; p < dataset.nrRows; ++p) {
                    double valSum = 0.0;
                    int nr = 0;
                    boolean foundNA = false;
                    for (int s3 = 0; s3 < dataset.nrCols; ++s3) {
                        if (!Double.isNaN(dataset.rawData[p][s3])) {
                            valSum += dataset.rawData[p][s3];
                            ++nr;
                            continue;
                        }
                        foundNA = true;
                    }
                    if (!foundNA) continue;
                    double mean = valSum / (double)nr;
                    for (int s4 = 0; s4 < dataset.nrCols; ++s4) {
                        if (!Double.isNaN(dataset.rawData[p][s4])) continue;
                        dataset.rawData[p][s4] = mean;
                    }
                }
            } else {
                for (s = 0; s < dataset.nrCols; ++s) {
                    double valSum = 0.0;
                    int nr = 0;
                    boolean foundNA = false;
                    for (int p = 0; p < dataset.nrRows; ++p) {
                        if (!Double.isNaN(dataset.rawData[p][s])) {
                            valSum += dataset.rawData[p][s];
                            ++nr;
                            continue;
                        }
                        foundNA = true;
                    }
                    if (!foundNA) continue;
                    double mean = valSum / (double)nr;
                    for (int p2 = 0; p2 < dataset.nrRows; ++p2) {
                        if (!Double.isNaN(dataset.rawData[p2][s])) continue;
                        dataset.rawData[p2][s] = mean;
                    }
                }
            }
            System.out.println("Quantile normalization round 2");
            QuantileNormalization.quantilenormalize(dataset.rawData);
        }
    }
}

