/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix2;

import JSci.maths.ArrayMath;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import umcg.genetica.math.matrix2.DoubleMatrixDataset;

public class MatrixHandling {
    public static void RemoveColumnsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerColumn, double missingValue) {
        HashSet<String> columnsToInclude = new HashSet<String>();
        for (int c = 0; c < dataset.columns(); ++c) {
            int nrMissing = 0;
            for (int r = 0; r < dataset.rows(); ++r) {
                if (dataset.getMatrix().get(r, c) != missingValue && !Double.isNaN(dataset.getMatrix().get(r, c))) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerColumn) {
                System.out.println("Excluding:\t" + c + "\t" + dataset.getColObjects().get(c) + "\t" + nrMissing);
                continue;
            }
            columnsToInclude.add(dataset.getColObjects().get(c));
        }
        MatrixHandling.CreatSubsetBasedOnColumns(dataset, columnsToInclude, true);
    }

    public static void RemoveRowsWithToManyMissingValues(DoubleMatrixDataset<String, String> dataset, int maxMissingValuesPerRow, double missingValue) {
        String[] rowNames = dataset.getRowObjects().toArray(new String[0]);
        HashSet<String> hashRowsToInclude = new HashSet<String>();
        for (int r = 0; r < dataset.rows(); ++r) {
            int nrMissing = 0;
            for (int c = 0; c < dataset.columns(); ++c) {
                if (dataset.getMatrix().get(r, c) != missingValue && !Double.isNaN(dataset.getMatrix().get(r, c))) continue;
                ++nrMissing;
            }
            if (nrMissing >= maxMissingValuesPerRow) {
                System.out.println("Excluding:\t" + r + "\t" + rowNames[r] + "\t" + nrMissing);
                continue;
            }
            hashRowsToInclude.add(rowNames[r]);
        }
        MatrixHandling.CreatSubsetBasedOnRows(dataset, hashRowsToInclude, false);
    }

    public static void RemoveDuplicatesSamples(DoubleMatrixDataset<String, String> dataset) {
        HashSet<String> removeEntry = new HashSet<String>();
        for (int c = 0; c < dataset.columns(); ++c) {
            DoubleMatrix1D colc = dataset.getMatrix().viewColumn(c);
            for (int c2 = 0; c2 < dataset.columns(); ++c2) {
                DoubleMatrix1D colc2 = dataset.getMatrix().viewColumn(c2);
                boolean identical = true;
                for (int r = 0; r < dataset.rows(); ++r) {
                    if (colc.getQuick(r) == colc2.getQuick(r)) continue;
                    identical = false;
                    break;
                }
                if (!identical) continue;
                removeEntry.add(dataset.getColObjects().get(c));
            }
        }
        if (removeEntry.size() > 0) {
            MatrixHandling.RemoveColumns(dataset, removeEntry);
        }
    }

    public static void appendPrefixToColnames(DoubleMatrixDataset<String, String> in, String prefix) {
        LinkedHashMap<String, Integer> newColObjects = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> t : in.getHashCols().entrySet()) {
            StringBuilder colName = new StringBuilder();
            colName.append(prefix);
            colName.append("_");
            colName.append(t);
            newColObjects.put(colName.toString(), t.getValue());
        }
        in.setHashCols(newColObjects);
    }

    public static void ReplaceMissingValuesPerColumn(DoubleMatrix2D rawData, boolean useMedian, double NaValue) {
        for (int s = 0; s < rawData.columns(); ++s) {
            System.out.println("Processing sample: " + s);
            boolean needsReplacement = false;
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int p = 0; p < rawData.rows(); ++p) {
                if (rawData.get(p, s) == NaValue) {
                    needsReplacement = true;
                    continue;
                }
                nonNAvalues.add(rawData.get(p, s));
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int p = 0; p < rawData.rows(); ++p) {
                if (rawData.get(p, s) != NaValue) continue;
                rawData.set(p, s, replacementValue);
            }
        }
    }

    public static void ReplaceMissingValuesPerRow(DoubleMatrix2D rawData, boolean useMedian, double NaValue) {
        for (int p = 0; p < rawData.rows(); ++p) {
            System.out.println("Processing row: " + p);
            boolean needsReplacement = false;
            ArrayDoubleList nonNAvalues = new ArrayDoubleList();
            for (int s = 0; s < rawData.rows(); ++s) {
                if (rawData.get(p, s) == NaValue) {
                    needsReplacement = true;
                    continue;
                }
                nonNAvalues.add(rawData.get(p, s));
            }
            if (!needsReplacement) continue;
            double replacementValue = useMedian ? ArrayMath.median((double[])nonNAvalues.toArray(new double[0])) : ArrayMath.mean((double[])nonNAvalues.toArray(new double[0]));
            for (int s = 0; s < rawData.rows(); ++s) {
                if (rawData.get(p, s) != NaValue) continue;
                rawData.set(p, s, replacementValue);
            }
        }
    }

    public static DoubleMatrixDataset<String, String> RemoveProbes(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnRows(dataset, probesToBeRemoved, true);
    }

    private static void fixOrdering(LinkedHashMap<String, Integer> hashMap) {
        int i = 0;
        for (Map.Entry<String, Integer> e : hashMap.entrySet()) {
            e.setValue(i);
            ++i;
        }
    }

    public static void RenameRows(DoubleMatrixDataset<String, ?> dataset, HashMap<String, String> mappedProbeList) {
        LinkedHashMap<String, Integer> newRowNames = new LinkedHashMap<String, Integer>(dataset.rows());
        for (Map.Entry<String, Integer> e : dataset.getHashRows().entrySet()) {
            if (mappedProbeList.containsKey(e.getKey())) {
                newRowNames.put(mappedProbeList.get(e.getKey()), e.getValue());
                continue;
            }
            newRowNames.put(e.getKey(), e.getValue());
        }
        dataset.setHashRows(newRowNames);
    }

    public DoubleMatrixDataset<String, String> RemoveRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> probesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnRows(dataset, probesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> CreatSubsetBasedOnRows(DoubleMatrixDataset<String, String> dataset, HashSet<String> rowNames, boolean removeRows) {
        int s;
        int p;
        int newSize = 0;
        HashSet<String> removeList = new HashSet<String>();
        if (removeRows) {
            for (String t : dataset.getRowObjects()) {
                if (!rowNames.contains(t)) {
                    ++newSize;
                    continue;
                }
                removeList.add(t);
            }
            if (removeList.isEmpty()) {
                return dataset;
            }
        } else {
            for (String t : dataset.getRowObjects()) {
                if (rowNames.contains(t)) {
                    ++newSize;
                    continue;
                }
                removeList.add(t);
            }
            if (newSize == dataset.rows()) {
                return dataset;
            }
        }
        Object matrix = (long)dataset.columns() * (long)newSize < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(newSize, dataset.columns()) : new DenseLargeDoubleMatrix2D(newSize, dataset.columns());
        int probeId = -1;
        ArrayList<String> rowObj = dataset.getRowObjects();
        if (removeRows) {
            for (p = 0; p < dataset.rows(); ++p) {
                if (rowNames.contains(rowObj.get(p))) continue;
                ++probeId;
                for (s = 0; s < dataset.columns(); ++s) {
                    matrix.setQuick(p, s, dataset.getMatrix().getQuick(p, s));
                }
            }
        } else {
            for (p = 0; p < dataset.rows(); ++p) {
                if (!rowNames.contains(rowObj.get(p))) continue;
                ++probeId;
                for (s = 0; s < dataset.columns(); ++s) {
                    matrix.setQuick(p, s, dataset.getMatrix().getQuick(p, s));
                }
            }
        }
        for (String r : removeList) {
            dataset.hashRows.remove(r);
        }
        MatrixHandling.fixOrdering(dataset.hashRows);
        return new DoubleMatrixDataset<String, String>((DoubleMatrix2D)matrix, dataset.hashRows, dataset.hashCols);
    }

    public static DoubleMatrixDataset<String, String> RemoveSamples(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnColumns(dataset, samplesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> RemoveColumns(DoubleMatrixDataset<String, String> dataset, HashSet<String> samplesToBeRemoved) {
        return MatrixHandling.CreatSubsetBasedOnColumns(dataset, samplesToBeRemoved, true);
    }

    public static DoubleMatrixDataset<String, String> CreatSubsetBasedOnColumns(DoubleMatrixDataset<String, String> dataset, HashSet<String> colNames, boolean remove) {
        int p;
        int s;
        int newSize = 0;
        HashSet<String> removeList = new HashSet<String>();
        if (remove) {
            for (String t : dataset.getColObjects()) {
                if (!colNames.contains(t)) {
                    ++newSize;
                    continue;
                }
                removeList.add(t);
            }
            if (removeList.isEmpty()) {
                return dataset;
            }
        } else {
            for (String t : dataset.getColObjects()) {
                if (colNames.contains(t)) {
                    ++newSize;
                    continue;
                }
                removeList.add(t);
            }
            if (newSize == dataset.columns()) {
                return dataset;
            }
        }
        Object matrix = (long)dataset.rows() * (long)newSize < 0x7FFFFFFDL ? new DenseDoubleMatrix2D(dataset.rows(), newSize) : new DenseLargeDoubleMatrix2D(dataset.rows(), newSize);
        int sampleId = -1;
        ArrayList<String> colObj = dataset.getColObjects();
        if (remove) {
            for (s = 0; s < dataset.columns(); ++s) {
                if (colNames.contains(colObj.get(s))) continue;
                ++sampleId;
                for (p = 0; p < dataset.rows(); ++p) {
                    matrix.setQuick(p, sampleId, dataset.getMatrix().getQuick(p, s));
                }
            }
        } else {
            for (s = 0; s < dataset.columns(); ++s) {
                if (!colNames.contains(colObj.get(s))) continue;
                ++sampleId;
                for (p = 0; p < dataset.rows(); ++p) {
                    matrix.setQuick(p, sampleId, dataset.getMatrix().getQuick(p, s));
                }
            }
        }
        for (String r : removeList) {
            dataset.hashCols.remove(r);
        }
        MatrixHandling.fixOrdering(dataset.hashCols);
        return new DoubleMatrixDataset<String, String>((DoubleMatrix2D)matrix, dataset.hashRows, dataset.hashCols);
    }

    public static void RenameCols(DoubleMatrixDataset<?, String> dataset, HashMap<String, String> newNames) {
        LinkedHashMap<String, Integer> newColNames = new LinkedHashMap<String, Integer>(dataset.columns());
        for (Map.Entry<String, Integer> e : dataset.getHashCols().entrySet()) {
            if (newNames.containsKey(e.getKey())) {
                newColNames.put(newNames.get(e.getKey()), e.getValue());
                continue;
            }
            newColNames.put(e.getKey(), e.getValue());
        }
        dataset.setHashCols(newColNames);
    }
}

