/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.matrix;

import JSci.maths.ArrayMath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import umcg.genetica.console.ProgressBar;
import umcg.genetica.containers.Triple;
import umcg.genetica.io.concurrent.DoubleParseTask;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.math.matrix.DoubleMatrixDatasetAC;
import umcg.genetica.math.matrix.SymmetricByteDistanceMatrix;

@Deprecated
public class DoubleMatrixDataset<T, U>
extends DoubleMatrixDatasetAC<T, U> {
    private static final Logger LOGGER = Logger.getLogger(DoubleMatrixDataset.class.getName());
    public double[][] rawData = null;
    public Set<T> rowsToInclude = null;
    public Set<U> colsToInclude = null;
    public String fileName = null;
    private int columnOffset = -1;

    public DoubleMatrixDataset() {
    }

    public DoubleMatrixDataset(String fileName) throws IOException {
        this(fileName, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDataset(String fileName, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            this.loadExpressionData(fileName, "\t");
        }
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude) throws IOException {
        this(fileName, rowsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        this.rowsToInclude = rowsToInclude;
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            this.loadExpressionData(fileName, "\t");
        }
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude) throws IOException {
        this(fileName, rowsToInclude, colsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH);
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude, int columnOffset) throws IOException {
        this(fileName, rowsToInclude, colsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH, columnOffset);
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException {
        this(fileName, rowsToInclude, colsToInclude, DoubleMatrixDatasetAC.LoadLabels.LOAD_BOTH, 1);
    }

    public DoubleMatrixDataset(String fileName, Set<T> rowsToInclude, Set<U> colsToInclude, DoubleMatrixDatasetAC.LoadLabels ll, int columnOffset) throws IOException {
        this.rowsToInclude = rowsToInclude;
        this.colsToInclude = colsToInclude;
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        if (fileName.endsWith(".binary")) {
            try {
                this.loadExpressionDataInBinaryFormat(fileName, ll);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        } else {
            this.loadExpressionData(fileName, "\t", columnOffset);
        }
    }

    public DoubleMatrixDataset(String fileName, String delimiter) throws IOException {
        if (!fileName.endsWith(".txt") && !fileName.endsWith(".txt.gz")) {
            throw new IllegalArgumentException("File type must be .txt when delimiter is given (given filename: " + fileName + ")");
        }
        LOGGER.log(Level.INFO, "Loading dataset: {0}", fileName);
        this.loadExpressionData(fileName, delimiter);
    }

    public DoubleMatrixDataset(double[][] data) {
        this(data.length, data[0].length);
        this.rawData = data;
    }

    public DoubleMatrixDataset(double[][] data, List<U> rowNames, List<T> columnNames) {
        if (data == null || rowNames == null || columnNames == null) {
            throw new IllegalArgumentException("Invalid constructor invocation: supply raw data, column and row names");
        }
        if (data.length != rowNames.size()) {
            throw new IllegalArgumentException("Length of matrix does not correspond to number of row names: " + data.length + " vs " + rowNames.size());
        }
        if (data[0].length != columnNames.size()) {
            throw new IllegalArgumentException("Length of matrix does not correspond to number of col names: " + data[0].length + " vs " + columnNames.size());
        }
        this.rawData = data;
        this.rowObjects = rowNames;
        this.colObjects = columnNames;
        this.nrCols = this.colObjects.size();
        this.nrRows = this.rowObjects.size();
        this.recalculateHashMaps();
    }

    public DoubleMatrixDataset(int nrRows, int nrCols) {
        int i;
        this.nrRows = nrRows;
        this.nrCols = nrCols;
        this.rowObjects = new ArrayList(nrRows);
        for (i = 0; i < nrRows; ++i) {
            this.rowObjects.add(null);
        }
        this.colObjects = new ArrayList(nrCols);
        for (i = 0; i < nrCols; ++i) {
            this.colObjects.add(null);
        }
        this.rawData = new double[nrRows][nrCols];
    }

    private void loadExpressionDataInBinaryFormat(String fileName, DoubleMatrixDatasetAC.LoadLabels ll) throws IOException, ClassNotFoundException {
        this.fileName = fileName;
        File fileBinary = new File(fileName + ".dat");
        BufferedInputStream in = null;
        int nrRowsThisBinaryFile = -1;
        int nrColsThisBinaryFile = -1;
        in = new BufferedInputStream(new FileInputStream(fileBinary));
        byte[] bytes = new byte[4];
        in.read(bytes, 0, 4);
        nrRowsThisBinaryFile = this.byteArrayToInt(bytes);
        in.read(bytes, 0, 4);
        nrColsThisBinaryFile = this.byteArrayToInt(bytes);
        if (this.rowsToInclude == null && this.colsToInclude == null) {
            this.nrRows = nrRowsThisBinaryFile;
            this.nrCols = nrColsThisBinaryFile;
            this.rawData = new double[this.nrRows][this.nrCols];
            switch (ll) {
                case LOAD_BOTH: {
                    this.loadRowObjects(fileName);
                    this.loadColumnObjects(fileName);
                    break;
                }
                case LOAD_ROWS: {
                    this.loadRowObjects(fileName);
                    break;
                }
                case LOAD_COLUMNS: {
                    this.loadColumnObjects(fileName);
                }
            }
            byte[] buffer = new byte[this.nrCols * 8];
            long bits = 0L;
            for (int row = 0; row < this.nrRows; ++row) {
                in.read(buffer, 0, this.nrCols * 8);
                int bufferLoc = 0;
                for (int col = 0; col < this.nrCols; ++col) {
                    bits = (long)(0xFF & buffer[bufferLoc + 7]) | (long)(0xFF & buffer[bufferLoc + 6]) << 8 | (long)(0xFF & buffer[bufferLoc + 5]) << 16 | (long)(0xFF & buffer[bufferLoc + 4]) << 24 | (long)(0xFF & buffer[bufferLoc + 3]) << 32 | (long)(0xFF & buffer[bufferLoc + 2]) << 40 | (long)(0xFF & buffer[bufferLoc + 1]) << 48 | (long)buffer[bufferLoc] << 56;
                    this.rawData[row][col] = Double.longBitsToDouble(bits);
                    bufferLoc += 8;
                }
            }
            in.close();
        } else {
            int[] rowSubsetIndex = this.loadRowObjects(fileName, nrRowsThisBinaryFile);
            int[] colSubsetIndex = this.loadColumnObjects(fileName, nrColsThisBinaryFile);
            this.rawData = new double[this.nrRows][this.nrCols];
            byte[] buffer = new byte[nrColsThisBinaryFile * 8];
            long bits = 0L;
            for (int row = 0; row < nrRowsThisBinaryFile; ++row) {
                in.read(buffer, 0, nrColsThisBinaryFile * 8);
                int bufferLoc = 0;
                for (int col = 0; col < nrColsThisBinaryFile; ++col) {
                    bits = (long)(0xFF & buffer[bufferLoc + 7]) | (long)(0xFF & buffer[bufferLoc + 6]) << 8 | (long)(0xFF & buffer[bufferLoc + 5]) << 16 | (long)(0xFF & buffer[bufferLoc + 4]) << 24 | (long)(0xFF & buffer[bufferLoc + 3]) << 32 | (long)(0xFF & buffer[bufferLoc + 2]) << 40 | (long)(0xFF & buffer[bufferLoc + 1]) << 48 | (long)buffer[bufferLoc] << 56;
                    int rowI = rowSubsetIndex[row];
                    int colI = colSubsetIndex[col];
                    if (rowI != -1 && colI != -1) {
                        this.rawData[rowI][colI] = Double.longBitsToDouble(bits);
                    }
                    bufferLoc += 8;
                }
            }
            in.close();
        }
        this.recalculateHashMaps();
        LOGGER.log(Level.INFO, "Binary file ''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, this.nrRows, this.nrCols});
    }

    public void loadExpressionData(String fileName, String delimiter, int columnOffset) throws IOException {
        this.columnOffset = columnOffset;
        this.loadExpressionData(fileName, delimiter);
    }

    private void loadExpressionData(String fileName, String delimiter) throws IOException {
        Pattern p = Pattern.compile(delimiter);
        this.fileName = fileName;
        int sampleOffset = 1;
        int[] sampleIndex = null;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = p.split(str);
        if (this.colsToInclude != null) {
            this.nrCols = 0;
            this.colObjects = new ArrayList();
            ArrayList<Integer> colIndicesToInclude = new ArrayList<Integer>();
            for (int s = 0; s < data.length - sampleOffset; ++s) {
                if (!this.colsToInclude.contains(data[s + sampleOffset])) continue;
                this.colObjects.add(data[s + sampleOffset]);
                this.hashCols.put(this.colObjects.get(this.nrCols), s);
                colIndicesToInclude.add(s);
                ++this.nrCols;
            }
            sampleIndex = new int[this.nrCols];
            int len = colIndicesToInclude.size();
            for (int i = 0; i < len; ++i) {
                sampleIndex[i] = (Integer)colIndicesToInclude.get(i);
            }
        } else {
            this.nrCols = data.length - sampleOffset;
            this.colObjects = new ArrayList(this.nrCols);
            sampleIndex = new int[this.nrCols];
            for (int s = 0; s < this.nrCols; ++s) {
                this.colObjects.add(data[s + sampleOffset]);
                this.hashCols.put(this.colObjects.get(s), s);
                sampleIndex[s] = s;
            }
        }
        this.nrRows = 0;
        while ((str = in.readLine()) != null) {
            if (this.rowsToInclude == null) {
                ++this.nrRows;
                continue;
            }
            String[] split = p.split(str);
            if (!this.rowsToInclude.contains(split[0])) continue;
            ++this.nrRows;
        }
        in.close();
        this.rawData = new double[this.nrRows][this.nrCols];
        this.rowObjects = new ArrayList(this.nrRows);
        in.open();
        in.readLine();
        int row = 0;
        boolean correctData = true;
        ProgressBar pb = new ProgressBar(this.nrRows);
        while ((str = in.readLine()) != null) {
            data = p.split(str);
            if (this.rowsToInclude == null || this.rowsToInclude.contains(data[0])) {
                this.rowObjects.add(new String(data[0].getBytes()));
                this.hashRows.put(this.rowObjects.get(row), row);
                for (int s = 0; s < this.nrCols; ++s) {
                    double d;
                    String cell = data[sampleIndex[s] + sampleOffset];
                    try {
                        d = Double.parseDouble(cell);
                    }
                    catch (NumberFormatException e) {
                        correctData = false;
                        d = Double.NaN;
                    }
                    this.rawData[row][s] = d;
                }
                ++row;
            }
            pb.iterate();
        }
        pb.close();
        if (!correctData) {
            LOGGER.warning("Your data contains NaN/unparseable values!");
        }
        in.close();
        this.recalculateHashMaps();
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, this.nrRows, this.nrCols});
    }

    private void loadExpressionDataParallel(String fileName, String delimiter) throws IOException {
        Pattern p = Pattern.compile(delimiter);
        this.fileName = fileName;
        this.columnOffset = 1;
        int[] colIndex = null;
        TextFile in = new TextFile(fileName, false);
        String str = in.readLine();
        String[] data = p.split(str);
        if (this.colsToInclude == null) {
            this.nrCols = data.length - this.columnOffset;
            this.colObjects = new ArrayList(this.nrCols);
            colIndex = new int[this.nrCols];
            for (int s = 0; s < this.nrCols; ++s) {
                String colName = data[s + this.columnOffset];
                this.colObjects.add(colName);
                this.hashCols.put(colName, s);
                colIndex[s] = s + this.columnOffset;
            }
        } else {
            String colName;
            int s;
            int nrMaxCols = data.length - this.columnOffset;
            int colCtr = 0;
            for (s = 0; s < nrMaxCols; ++s) {
                colName = data[s + this.columnOffset];
                if (!this.colsToInclude.contains(colName)) continue;
                ++colCtr;
            }
            this.colObjects = new ArrayList(colCtr);
            colIndex = new int[colCtr];
            this.nrCols = colCtr;
            colCtr = 0;
            for (s = 0; s < nrMaxCols; ++s) {
                colName = data[s + this.columnOffset];
                if (!this.colsToInclude.contains(colName)) continue;
                this.colObjects.add(colName);
                this.hashCols.put(colName, colCtr);
                colIndex[colCtr] = s + this.columnOffset;
                ++colCtr;
            }
        }
        this.nrRows = 0;
        ArrayList<String> rowNames = new ArrayList<String>();
        while ((str = in.readLine()) != null) {
            String[] split = p.split(str);
            if (this.rowsToInclude == null) {
                rowNames.add(split[0]);
                ++this.nrRows;
                continue;
            }
            if (!this.rowsToInclude.contains(split[0])) continue;
            rowNames.add(split[0]);
            ++this.nrRows;
        }
        in.close();
        this.rowObjects = new ArrayList(this.nrRows);
        for (int i = 0; i < rowNames.size(); ++i) {
            this.rowObjects.add(rowNames.get(i));
            this.hashRows.put(rowNames.get(i), i);
        }
        this.rawData = new double[this.nrRows][this.nrCols];
        in.open();
        str = in.readLine();
        int nrprocs = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(nrprocs);
        ExecutorCompletionService<Triple<Integer, String, double[]>> pool = new ExecutorCompletionService<Triple<Integer, String, double[]>>(threadPool);
        int tasksSubmitted = 0;
        int returnedResults = 0;
        int lnctr = 0;
        while ((str = in.readLine()) != null) {
            DoubleParseTask task = new DoubleParseTask(str, this.columnOffset, lnctr, colIndex, this.rowsToInclude, p);
            pool.submit(task);
            ++tasksSubmitted;
            if (lnctr % (nrprocs * 2) == 0) {
                while (returnedResults < tasksSubmitted) {
                    try {
                        Triple result = (Triple)pool.take().get();
                        if (result == null) continue;
                        int rownr = (Integer)result.getLeft();
                        if (rownr >= 0) {
                            double[] doubles = (double[])result.getRight();
                            this.rawData[rownr] = doubles;
                        }
                        result = null;
                        ++returnedResults;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++lnctr;
        }
        while (returnedResults < tasksSubmitted) {
            try {
                Triple result = (Triple)pool.take().get();
                if (result == null) continue;
                int rownr = (Integer)result.getLeft();
                if (rownr >= 0) {
                    double[] doubles = (double[])result.getRight();
                    this.rawData[rownr] = doubles;
                }
                result = null;
                ++returnedResults;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        threadPool.shutdown();
        in.close();
        LOGGER.log(Level.INFO, "''{0}'' has been loaded, nrRows: {1} nrCols: {2}", new Object[]{fileName, this.nrRows, this.nrCols});
    }

    private int[] loadRowObjects(String fileName, int nrRowsThisBinaryFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        int[] rowSubsetIndex = new int[nrRowsThisBinaryFile];
        for (int r = 0; r < rowSubsetIndex.length; ++r) {
            rowSubsetIndex[r] = -1;
        }
        File fileRows = new File(fileName + ".rows.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileRows));
        ObjectInputStream ois = new ObjectInputStream(bis);
        int rowIndex = 0;
        this.rowObjects = new ArrayList();
        HashMap<Object, Integer> hashRowsPresentAndRequested = new HashMap<Object, Integer>();
        while (bis.available() > 0) {
            Object rowObject = ois.readObject();
            if (this.rowsToInclude == null || this.rowsToInclude.contains(rowObject)) {
                rowSubsetIndex[rowIndex] = hashRowsPresentAndRequested.size();
                hashRowsPresentAndRequested.put(rowObject, rowIndex);
                this.rowObjects.add(rowObject);
            }
            ++rowIndex;
        }
        bis.close();
        ois.close();
        this.nrRows = hashRowsPresentAndRequested.size();
        return rowSubsetIndex;
    }

    public static List<Object> getRowObjectsOnly(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        File fileRows = new File(fileName + ".rows.ser");
        ArrayList<Object> objects = new ArrayList<Object>();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileRows));
        ObjectInputStream ois = new ObjectInputStream(bis);
        while (bis.available() > 0) {
            objects.add(ois.readObject());
        }
        bis.close();
        ois.close();
        return objects;
    }

    public static List<Object> getColumnObjectsOnly(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        File fileCols = new File(fileName + ".columns.ser");
        ArrayList<Object> objects = new ArrayList<Object>();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileCols));
        ObjectInputStream ois = new ObjectInputStream(bis);
        while (bis.available() > 0) {
            objects.add(ois.readObject());
        }
        bis.close();
        ois.close();
        return objects;
    }

    private void loadRowObjects(String fileName) throws FileNotFoundException, IOException {
        this.rowObjects = new ArrayList(this.nrRows);
        File fileRows = new File(fileName + ".rows.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileRows));
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            while (bis.available() > 0) {
                this.rowObjects.add(ois.readObject());
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DoubleMatrixDataset.class.getName()).log(Level.SEVERE, "Error with row objects", ex);
            ex.printStackTrace();
        }
        bis.close();
        ois.close();
        if (this.rowObjects.size() != this.nrRows) {
            throw new IOException("The number of row objects in " + fileRows.getName() + " doesn't match the number of rows in " + fileName + ".dat");
        }
    }

    private int[] loadColumnObjects(String fileName, int nrColsThisBinaryFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        int[] colSubsetIndex = new int[nrColsThisBinaryFile];
        for (int c = 0; c < colSubsetIndex.length; ++c) {
            colSubsetIndex[c] = -1;
        }
        File fileCols = new File(fileName + ".columns.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileCols));
        ObjectInputStream ois = new ObjectInputStream(bis);
        int colIndex = 0;
        this.colObjects = new ArrayList();
        HashMap<Object, Integer> hashColsPresentAndRequested = new HashMap<Object, Integer>();
        while (bis.available() > 0) {
            Object colObject = ois.readObject();
            if (this.colsToInclude == null || this.colsToInclude.contains(colObject)) {
                colSubsetIndex[colIndex] = hashColsPresentAndRequested.size();
                hashColsPresentAndRequested.put(colObject, colIndex);
                this.colObjects.add(colObject);
            }
            ++colIndex;
        }
        bis.close();
        ois.close();
        this.nrCols = hashColsPresentAndRequested.size();
        return colSubsetIndex;
    }

    private void loadColumnObjects(String fileName) throws FileNotFoundException, IOException {
        this.colObjects = new ArrayList(this.nrCols);
        File fileCols = new File(fileName + ".columns.ser");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileCols));
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            while (bis.available() > 0) {
                this.colObjects.add(ois.readObject());
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DoubleMatrixDataset.class.getName()).log(Level.SEVERE, "Error with column objects", ex);
            ex.printStackTrace();
        }
        bis.close();
        ois.close();
        if (this.colObjects.size() != this.nrCols) {
            throw new IOException("The number of column objects in " + fileCols.getName() + " doesn't match the number of columns in " + fileName + ".dat");
        }
    }

    @Override
    public void recalculateHashMaps() {
        if (this.rowObjects != null) {
            this.nrRows = this.rowObjects.size();
            this.hashRows.clear();
            for (int probeItr = 0; probeItr < this.nrRows; ++probeItr) {
                this.hashRows.put(this.rowObjects.get(probeItr), probeItr);
            }
        }
        if (this.colObjects != null) {
            this.nrCols = this.colObjects.size();
            this.hashCols.clear();
            for (int sampleItr = 0; sampleItr < this.nrCols; ++sampleItr) {
                this.hashCols.put(this.colObjects.get(sampleItr), sampleItr);
            }
        }
    }

    public void transposeDataset() {
        int i;
        this.rawData = this.getRawDataTransposed();
        int nrColsTemp = this.rowObjects.size();
        List colObjsTemp = this.rowObjects;
        this.nrRows = this.colObjects.size();
        this.rowObjects = new ArrayList();
        for (i = 0; i < this.nrRows; ++i) {
            this.rowObjects.add(this.colObjects.get(i));
        }
        this.nrCols = nrColsTemp;
        this.colObjects = new ArrayList();
        for (i = 0; i < this.nrCols; ++i) {
            this.colObjects.add(colObjsTemp.get(i));
        }
        this.recalculateHashMaps();
    }

    public double[][] getRawDataTransposed() {
        double[][] rawDataTransposed = new double[this.nrCols][this.nrRows];
        for (int s = 0; s < this.nrCols; ++s) {
            for (int p = 0; p < this.nrRows; ++p) {
                rawDataTransposed[s][p] = this.rawData[p][s];
            }
        }
        return rawDataTransposed;
    }

    public void calculateProbeCoexpression(String outputFile) throws IOException {
        this.standardNormalizeData();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        SymmetricByteDistanceMatrix matrix = new SymmetricByteDistanceMatrix(this.nrRows);
        int sampleCountMinusOne = this.nrCols - 1;
        long[] corrDist = new long[201];
        for (int f = 0; f < this.nrRows; ++f) {
            for (int g = f + 1; g < this.nrRows; ++g) {
                int corrIndex;
                double covariance;
                double covarianceInterim = 0.0;
                for (int s = 0; s < this.nrCols; ++s) {
                    covarianceInterim += this.rawData[f][s] * this.rawData[g][s];
                }
                double correlation = covariance = covarianceInterim / (double)sampleCountMinusOne;
                int n = corrIndex = (int)Math.round((correlation + 1.0) * 100.0);
                corrDist[n] = corrDist[n] + 1L;
                matrix.set(f, g, corrIndex);
            }
            if (f % 1000 != 999) continue;
            LOGGER.log(Level.INFO, "{0} Probes processed", f + 1);
        }
        matrix.save(new File(outputFile));
        TextFile out = new TextFile(outputFile + "-MatrixProbes.txt", true);
        for (int f = 0; f < this.nrRows; ++f) {
            out.write(this.rowObjects.get(f) + "\t" + this.rowObjects.get(f) + "\n");
        }
        out.close();
    }

    public void standardNormalizeData() {
        LOGGER.info("Setting probe mean to zero and stdev to one for every probe:");
        for (int probeID = 0; probeID < this.nrRows; ++probeID) {
            double[] vals = new double[this.nrCols];
            System.arraycopy(this.rawData[probeID], 0, vals, 0, this.nrCols);
            double mean = ArrayMath.mean((double[])vals);
            int s = 0;
            while (s < this.nrCols) {
                int n = s++;
                vals[n] = vals[n] - mean;
            }
            double standardDeviation = ArrayMath.standardDeviation((double[])vals);
            for (int s2 = 0; s2 < this.nrCols; ++s2) {
                this.rawData[probeID][s2] = (float)(vals[s2] / standardDeviation);
            }
        }
    }

    public void save(String fileName) throws IOException {
        if (fileName.endsWith(".binary") || fileName.endsWith(".dat")) {
            BufferedOutputStream out = null;
            File fileBinary = new File(fileName + ".dat");
            out = new BufferedOutputStream(new FileOutputStream(fileBinary));
            out.write(this.intToByteArray(this.nrRows));
            out.write(this.intToByteArray(this.nrCols));
            byte[] buffer = new byte[this.rawData[0].length * 8];
            for (int row = 0; row < this.rawData.length; ++row) {
                int bufferLoc = 0;
                for (int col = 0; col < this.rawData[0].length; ++col) {
                    long bits = Double.doubleToLongBits(this.rawData[row][col]);
                    buffer[bufferLoc] = (byte)(bits >> 56);
                    buffer[bufferLoc + 1] = (byte)(bits >> 48 & 0xFFL);
                    buffer[bufferLoc + 2] = (byte)(bits >> 40 & 0xFFL);
                    buffer[bufferLoc + 3] = (byte)(bits >> 32 & 0xFFL);
                    buffer[bufferLoc + 4] = (byte)(bits >> 24 & 0xFFL);
                    buffer[bufferLoc + 5] = (byte)(bits >> 16 & 0xFFL);
                    buffer[bufferLoc + 6] = (byte)(bits >> 8 & 0xFFL);
                    buffer[bufferLoc + 7] = (byte)(bits & 0xFFL);
                    bufferLoc += 8;
                }
                out.write(buffer);
            }
            out.close();
            File fileRows = new File(fileName + ".rows.ser");
            ObjectOutputStream outRows = new ObjectOutputStream(new FileOutputStream(fileRows));
            for (int p = 0; p < this.rawData.length; ++p) {
                outRows.writeObject(this.rowObjects.get(p));
            }
            outRows.close();
            File fileCols = new File(fileName + ".columns.ser");
            ObjectOutputStream outCols = new ObjectOutputStream(new FileOutputStream(fileCols));
            for (int p = 0; p < this.rawData[0].length; ++p) {
                outCols.writeObject(this.colObjects.get(p));
            }
            outCols.close();
        } else {
            TextFile out = new TextFile(fileName, true);
            out.append('-');
            for (int s = 0; s < this.rawData[0].length; ++s) {
                if (this.colObjects == null) continue;
                out.append('\t');
                out.append(String.valueOf(this.colObjects.get(s)));
            }
            out.append('\n');
            for (int p = 0; p < this.rawData.length; ++p) {
                if (this.rowObjects == null) {
                    out.append("");
                } else {
                    out.append(this.rowObjects.get(p).toString());
                }
                for (int s = 0; s < this.rawData[p].length; ++s) {
                    out.append('\t');
                    out.append(String.valueOf(this.rawData[p][s]));
                }
                out.append('\n');
            }
            out.close();
        }
    }

    @Override
    public double[] get(int x) {
        return this.rawData[x];
    }

    @Override
    public double get(int x, int y) {
        return this.rawData[x][y];
    }

    public DoubleMatrixDataset<U, T> getTransposedDataset() {
        DoubleMatrixDataset<T, U> transposed = new DoubleMatrixDataset<T, U>(this.getRawDataTransposed());
        transposed.rowObjects = this.colObjects;
        transposed.hashRows = this.hashCols;
        transposed.colObjects = this.rowObjects;
        transposed.hashCols = this.hashRows;
        return transposed;
    }

    public void removeColumnsWithNaNs() {
        HashSet<Integer> colsWithNaNs = new HashSet<Integer>();
        for (int i = 0; i < this.nrRows; ++i) {
            for (int j = 0; j < this.nrCols; ++j) {
                if (!Double.isNaN(this.rawData[i][j])) continue;
                colsWithNaNs.add(j);
            }
        }
        if (!colsWithNaNs.isEmpty()) {
            double[][] newData = new double[this.nrRows][this.nrCols - colsWithNaNs.size()];
            for (int i = 0; i < this.nrRows; ++i) {
                int colI = 0;
                for (int j = 0; j < this.nrCols; ++j) {
                    if (colsWithNaNs.contains(j)) continue;
                    newData[i][colI] = this.rawData[i][j];
                    ++colI;
                }
            }
            this.rawData = newData;
            this.colObjects.removeAll(colsWithNaNs);
            this.nrCols -= colsWithNaNs.size();
            this.recalculateHashMaps();
        }
    }

    private byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    public double[][] getRawData() {
        return this.rawData;
    }

    public void setRawData(double[][] rawData) {
        this.rawData = rawData;
    }
}

