/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.bin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import umcg.genetica.io.trityper.TriTyperGeneticalGenomicsDataset;
import umcg.genetica.io.trityper.bin.BinaryResultProbe;

public class BinaryResultProbeSummary {
    private DataOutputStream out;
    private int counter = 0;
    private DataInputStream in;
    public static boolean W = true;
    public static boolean R = false;

    public BinaryResultProbeSummary(String filename, boolean W) throws IOException {
        if (W) {
            this.out = new DataOutputStream(new FileOutputStream(new File(filename + ".ProbeSummary.dat")));
        } else {
            this.in = new DataInputStream(new FileInputStream(new File(filename)));
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
    }

    public void write(String[] probeList, Integer[][] probetranslation, TriTyperGeneticalGenomicsDataset[] gg) throws IOException {
        block0: for (int p = 0; p < probeList.length; ++p) {
            for (int d = 0; d < gg.length; ++d) {
                if (probetranslation[d][p] == null) continue;
                int probeId = probetranslation[d][p];
                int start = gg[d].getExpressionData().getChrStart()[probeId];
                int stop = gg[d].getExpressionData().getChrStart()[probeId];
                int midpoint = (int)Math.floor((double)(start + stop) / 2.0);
                this.out.writeInt(p);
                this.out.writeUTF(gg[d].getExpressionData().getProbes()[probeId]);
                this.out.writeByte(gg[d].getExpressionData().getChr()[probeId]);
                this.out.writeInt(midpoint);
                if (gg[d].getExpressionData().getAnnotation()[probeId] == null) {
                    this.out.writeUTF("-");
                    continue block0;
                }
                this.out.writeUTF(gg[d].getExpressionData().getAnnotation()[probeId]);
                continue block0;
            }
        }
    }

    public void write(String[] probeNames) throws IOException {
        for (int p = 0; p < probeNames.length; ++p) {
            this.out.writeInt(p);
            this.out.writeUTF(probeNames[p]);
            this.out.writeByte(127);
            this.out.writeInt(Integer.MAX_VALUE);
            this.out.writeUTF("-");
        }
    }

    public BinaryResultProbe[] readAllProbes() throws IOException {
        ArrayList<BinaryResultProbe> probes = new ArrayList<BinaryResultProbe>();
        BinaryResultProbe probe = this.readNextProbe();
        boolean ct = false;
        while (probe != null) {
            probes.add(probe);
            probe = this.readNextProbe();
        }
        BinaryResultProbe[] probelist = new BinaryResultProbe[probes.size()];
        for (int p = 0; p < probelist.length; ++p) {
            probelist[p] = (BinaryResultProbe)probes.get(p);
        }
        return probelist;
    }

    public BinaryResultProbe readNextProbe() throws IOException {
        BinaryResultProbe p = null;
        try {
            p = new BinaryResultProbe();
            p.setId(this.in.readInt());
            p.setName(this.in.readUTF());
            p.setChr(this.in.readByte());
            p.setMidpoint(this.in.readInt());
            p.setAnnotation(this.in.readUTF());
        }
        catch (EOFException e) {
            return null;
        }
        return p;
    }
}

