/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.regulomedb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import umcg.genetica.io.regulomedb.RegulomeDbEntry;
import umcg.genetica.io.regulomedb.RegulomeDbFile;

public class RegulomeDbIterator
implements Iterator<RegulomeDbEntry> {
    private Iterator<RegulomeDbFile> regulomeDbFilesIterator;
    private BufferedReader regulomeDbFileReader = null;
    private boolean hasNext;
    private RegulomeDbEntry next;

    public RegulomeDbIterator(RegulomeDbFile regulomeDbFile) {
        ArrayList<RegulomeDbFile> regulomeDbFiles = new ArrayList<RegulomeDbFile>(1);
        regulomeDbFiles.add(regulomeDbFile);
        this.regulomeDbFilesIterator = regulomeDbFiles.iterator();
        try {
            if (this.regulomeDbFilesIterator.hasNext()) {
                this.regulomeDbFileReader = new BufferedReader(new FileReader(this.regulomeDbFilesIterator.next().getRegulomeDbFile()));
                this.loadNext();
            } else {
                this.hasNext = false;
                this.next = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public RegulomeDbIterator(Collection<RegulomeDbFile> regulomeDbFiles) {
        this.regulomeDbFilesIterator = regulomeDbFiles.iterator();
        try {
            if (this.regulomeDbFilesIterator.hasNext()) {
                this.regulomeDbFileReader = new BufferedReader(new FileReader(this.regulomeDbFilesIterator.next().getRegulomeDbFile()));
                this.loadNext();
            } else {
                this.hasNext = false;
                this.next = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public RegulomeDbEntry next() {
        RegulomeDbEntry current = this.next;
        try {
            this.loadNext();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported ever.");
    }

    private void loadNext() throws IOException, Exception {
        String line = this.regulomeDbFileReader.readLine();
        if (line == null) {
            while (this.regulomeDbFilesIterator.hasNext()) {
                this.regulomeDbFileReader = new BufferedReader(new FileReader(this.regulomeDbFilesIterator.next().getRegulomeDbFile()));
                line = this.regulomeDbFileReader.readLine();
                if (line == null) continue;
                this.hasNext = true;
                this.next = new RegulomeDbEntry(line);
                return;
            }
            this.hasNext = false;
            this.next = null;
        } else {
            this.hasNext = true;
            this.next = new RegulomeDbEntry(line);
        }
    }
}

