/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.regulomedb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import umcg.genetica.io.regulomedb.RegulomeDbSupportingData;

public class RegulomeDbEntry {
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern SUPPORT_SEP_PATTERN = Pattern.compile(", ");
    private final String chr;
    private final int chrPos;
    private final String variantId;
    private final String regulomeDbScore;
    private final Map<String, List<RegulomeDbSupportingData>> supportData;

    public RegulomeDbEntry(String regulomeDbFileLine) throws Exception {
        String[] lineElements = TAB_PATTERN.split(regulomeDbFileLine);
        if (lineElements.length != 5) {
            throw new Exception("Error in RegulomeDB file. Expected 5 columns but found this: " + regulomeDbFileLine);
        }
        this.chr = lineElements[0];
        this.chrPos = Integer.parseInt(lineElements[1]);
        this.variantId = lineElements[2];
        this.regulomeDbScore = lineElements[4];
        HashMap<String, ArrayList> supportDataLoader = new HashMap<String, ArrayList>();
        if (!lineElements[3].equals(".")) {
            for (String supportDataElementString : SUPPORT_SEP_PATTERN.split(lineElements[3])) {
                ArrayList supportDataClassElements;
                RegulomeDbSupportingData supportDataElement = new RegulomeDbSupportingData(supportDataElementString);
                if (supportDataLoader.containsKey(supportDataElement.getSupportClass())) {
                    supportDataClassElements = (ArrayList)supportDataLoader.get(supportDataElement.getSupportClass());
                } else {
                    supportDataClassElements = new ArrayList();
                    supportDataLoader.put(supportDataElement.getSupportClass(), supportDataClassElements);
                }
                supportDataClassElements.add(supportDataElement);
            }
        }
        HashMap supportDataLoaderUnmodifiableLists = new HashMap();
        for (Map.Entry supportDataLoaderEntry : supportDataLoader.entrySet()) {
            supportDataLoaderUnmodifiableLists.put(supportDataLoaderEntry.getKey(), Collections.unmodifiableList((List)supportDataLoaderEntry.getValue()));
        }
        this.supportData = Collections.unmodifiableMap(supportDataLoaderUnmodifiableLists);
    }

    public String getChr() {
        return this.chr;
    }

    public int getChrPos() {
        return this.chrPos;
    }

    public String getVariantId() {
        return this.variantId;
    }

    public String getRegulomeDbScore() {
        return this.regulomeDbScore;
    }

    public Map<String, List<RegulomeDbSupportingData>> getSupportData() {
        return this.supportData;
    }

    public boolean hasSupportDataClass(String supportDataClass) {
        return this.supportData.containsKey(supportDataClass);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.chr != null ? this.chr.hashCode() : 0);
        hash = 61 * hash + this.chrPos;
        hash = 61 * hash + (this.variantId != null ? this.variantId.hashCode() : 0);
        hash = 61 * hash + (this.regulomeDbScore != null ? this.regulomeDbScore.hashCode() : 0);
        hash = 61 * hash + (this.supportData != null ? ((Object)this.supportData).hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegulomeDbEntry other = (RegulomeDbEntry)obj;
        if (this.chr == null ? other.chr != null : !this.chr.equals(other.chr)) {
            return false;
        }
        if (this.chrPos != other.chrPos) {
            return false;
        }
        if (this.variantId == null ? other.variantId != null : !this.variantId.equals(other.variantId)) {
            return false;
        }
        if (this.regulomeDbScore == null ? other.regulomeDbScore != null : !this.regulomeDbScore.equals(other.regulomeDbScore)) {
            return false;
        }
        return this.supportData == other.supportData || this.supportData != null && ((Object)this.supportData).equals(other.supportData);
    }
}

