/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.gtf;

import java.util.Collections;
import java.util.Map;

public class GffElement {
    private final String seqname;
    private final String source;
    private final String feature;
    private final int start;
    private final int end;
    private final float score;
    private final char strand;
    private final int frame;
    private final Map<String, String> attributes;

    public GffElement(String seqname, String source, String feature, int start, int end, float score, char strand, int frame, Map<String, String> attributes) {
        this.seqname = seqname;
        this.source = source;
        this.feature = feature;
        this.start = start;
        this.end = end;
        this.score = score;
        this.strand = strand;
        this.frame = frame;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public String getSeqname() {
        return this.seqname;
    }

    public String getSource() {
        return this.source;
    }

    public String getFeature() {
        return this.feature;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public float getScore() {
        return this.score;
    }

    public char getStrand() {
        return this.strand;
    }

    public int getFrame() {
        return this.frame;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }
}

