/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Gpio {
    public static String[] getListOfFiles(String dir, String extension, String containsThis, String doesntContainThis) {
        File loc = new File(dir);
        String[] fileList = loc.list();
        ArrayList<String> al = new ArrayList<String>();
        for (String fileloc : fileList) {
            String ext;
            String fname;
            String fileName;
            int mid;
            File file = new File(fileloc);
            if (file.isDirectory() || (mid = (fileName = file.getName()).lastIndexOf(".")) < 0 || !(fname = fileName.substring(0, mid)).contains(containsThis) || !doesntContainThis.isEmpty() && fname.contains(doesntContainThis) || !(ext = fileName.substring(mid + 1, fileName.length())).toLowerCase().equals(extension)) continue;
            al.add(loc.getAbsolutePath() + "/" + fileName);
        }
        String[] output = al.toArray(new String[0]);
        return output;
    }

    public static String[] getListOfFiles(String dir, String extension, String containsThis) {
        return Gpio.getListOfFiles(dir, extension, containsThis, "");
    }

    public static String[] getListOfFiles(String dir, String extension) {
        return Gpio.getListOfFiles(dir, extension, "", "");
    }

    public static void createDir(String dirName) throws IOException {
        boolean success;
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        if (!Gpio.exists(dirName) && (success = new File(dirName).mkdirs())) {
            System.out.println("Directory: " + dirName + " created");
        }
    }

    public static boolean isDir(String dir) {
        File loc = new File(dir);
        if (loc.isDirectory()) {
            loc = null;
            return true;
        }
        loc = null;
        return false;
    }

    public static boolean exists(String dir) {
        File file = new File(dir);
        boolean exists = file.exists();
        boolean readable = file.canRead();
        return exists & readable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String[] getListOfFiles(String dir) {
        File loc = new File(dir);
        String[] fileList = loc.list();
        return fileList;
    }

    public static long getFileSize(String fileName) {
        File f = new File(fileName);
        long size = f.length();
        return size;
    }

    public static String humanizeFileSize(long s) {
        String output = "";
        DecimalFormat df = new DecimalFormat("##.##");
        if (s == 0L) {
            output = "0b";
        } else if (s > 0x10000000000L) {
            double nrtb = (double)s / 1.099511627776E12;
            output = df.format(nrtb) + " TB";
        } else if (s > 0x40000000L) {
            double nrtb = (double)s / 1.073741824E9;
            output = df.format(nrtb) + " GB";
        } else if (s > 0x100000L) {
            double nrtb = (double)s / 1048576.0;
            output = df.format(nrtb) + " MB";
        } else if (s > 1024L) {
            double nrtb = (double)s / 1024.0;
            output = df.format(nrtb) + " KB";
        }
        return output;
    }

    public static void moveFile(String fileIn, String fileOut) throws IOException {
        File f1 = new File(fileIn);
        File f2 = new File(fileOut);
        Gpio.copyFile(f1, f2);
        f1.delete();
    }

    public static boolean canRead(String fileName) {
        File f = new File(fileName);
        return f.canRead();
    }

    public static boolean canWrite(String fileName) {
        File f = new File(fileName);
        return f.canWrite();
    }

    public static boolean canExecute(String fileName) {
        File f = new File(fileName);
        return f.canExecute();
    }

    public static String getParentDir(String file) {
        File f = new File(file);
        return f.getParent();
    }

    public static String getFileName(String file) {
        File f = new File(file);
        return f.getName();
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String formatAsDirectory(String loc) {
        if (!loc.endsWith(Gpio.getFileSeparator())) {
            loc = loc + Gpio.getFileSeparator();
        }
        return loc;
    }

    public static void copyFile(String filein, String fileout) throws IOException {
        Gpio.copyFile(new File(filein), new File(fileout));
    }
}

