/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.graphics;

import JSci.maths.ArrayMath;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Heatmap {
    private static final Font ROW_FONT = new Font("Verdana", 0, 14);
    private static final Font COL_FONT = new Font("Verdana", 0, 10);
    private static final Font LEGEND_FONT = new Font("Verdana", 0, 14);
    private static final int LEGEND_Y = 10;
    private static final int LEGEND_WIDTH = 200;
    private static final int LEGEND_HEIGHT = 100;
    private static final Logger LOGGER = Logger.getLogger(Heatmap.class.getName());

    public static void drawHeatmap(double[][] values, String[] rowHeaders, String[] colHeaders, int width, int height, String filename, Output output) throws IOException, DocumentException {
        if (values.length != rowHeaders.length) {
            throw new IllegalArgumentException("Data length and number of row headers differ!");
        }
        if (values[0].length != colHeaders.length) {
            throw new IllegalArgumentException("Data length and number of column headers differ!");
        }
        Graphics2D g2d = null;
        Document document = null;
        PdfWriter writer = null;
        PdfContentByte cb = null;
        BufferedImage bi = null;
        if (output == Output.PDF) {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            document = new Document(rectangle);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            document.open();
            cb = writer.getDirectContent();
            cb.saveState();
            g2d = cb.createGraphics((float)width, (float)height);
        } else {
            bi = new BufferedImage(width, height, 1);
            g2d = bi.createGraphics();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.setFont(ROW_FONT);
        FontMetrics fontmetrics = g2d.getFontMetrics();
        int leftMargin = 0;
        for (String s : rowHeaders) {
            leftMargin = Math.max(leftMargin, fontmetrics.stringWidth(s));
        }
        leftMargin += 10;
        g2d.setFont(COL_FONT);
        fontmetrics = g2d.getFontMetrics();
        int topMargin = 0;
        for (String s : colHeaders) {
            topMargin = Math.max(topMargin, fontmetrics.stringWidth(s));
        }
        topMargin += 10;
        int plotWidth = width - leftMargin;
        int plotHeight = height - (topMargin += 200);
        int tileW = (int)((double)plotWidth) / values[0].length;
        int tileH = (int)((double)plotHeight) / values.length;
        if (tileW < 3) {
            throw new IllegalArgumentException("Map tiles would become less than 3 pixels wide. Output a wider image or use less columns.");
        }
        if (tileH < 3) {
            throw new IllegalArgumentException("Map tiles would become less than 3 pixels tall. Output a wider image or use less rows.");
        }
        g2d.setFont(ROW_FONT);
        g2d.setColor(Color.black);
        for (int row = 0; row < values.length; ++row) {
            g2d.drawString(rowHeaders[row], 0, topMargin + row * tileH + tileH / 2 + 5);
        }
        g2d.setFont(COL_FONT);
        g2d.setColor(Color.black);
        for (int col = 0; col < values[0].length; ++col) {
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(colHeaders[col], -topMargin + 10, leftMargin + col * tileW + tileW / 2);
            g2d.rotate(1.5707963267948966);
        }
        double min = ArrayMath.min((double[][])values);
        double max = ArrayMath.max((double[][])values);
        Heatmap.normalize(values);
        for (int row = 0; row < values.length; ++row) {
            for (int col = 0; col < values[0].length; ++col) {
                g2d.setColor(Heatmap.getRGB(values[row][col]));
                g2d.fillRect(leftMargin + col * tileW, topMargin + row * tileH, tileW, tileH);
            }
        }
        int legendX = width - 200 - 20;
        GradientPaint gp = new GradientPaint(legendX, 10.0f, Color.blue, legendX + 100, 10.0f, Color.white);
        g2d.setPaint(gp);
        g2d.fillRect(legendX, 10, 100, 100);
        gp = new GradientPaint(legendX + 100, 10.0f, Color.white, legendX + 200, 10.0f, Color.red);
        g2d.setPaint(gp);
        g2d.fillRect(legendX + 100, 10, 100, 100);
        g2d.setColor(Color.black);
        g2d.setFont(LEGEND_FONT);
        String minStr = Math.round(min) + "";
        int stringWidth = fontmetrics.stringWidth(minStr);
        g2d.drawString(minStr, legendX - stringWidth / 2, 130);
        String avgStr = Math.round((max - min) / 2.0) + "";
        stringWidth = fontmetrics.stringWidth(avgStr);
        g2d.drawString(avgStr, legendX + 100 - stringWidth / 2, 130);
        String maxStr = Math.round(max) + "";
        stringWidth = fontmetrics.stringWidth(maxStr);
        g2d.drawString(maxStr, legendX + 200 - stringWidth / 2, 130);
        g2d.dispose();
        if (output == Output.PDF) {
            cb.restoreState();
            document.close();
            writer.close();
        } else {
            bi.flush();
            ImageIO.write((RenderedImage)bi, output.toString().toLowerCase(), new File(filename));
        }
    }

    public static void drawCorrelationHeatmap(double[][] values, String[] rowHeaders, String[] colHeaders, int width, int height, String filename, Output output) throws IOException, DocumentException {
        if (values.length != rowHeaders.length) {
            throw new IllegalArgumentException("Data length and number of row headers differ!");
        }
        if (values[0].length != colHeaders.length) {
            throw new IllegalArgumentException("Data length and number of column headers differ!");
        }
        Graphics2D g2d = null;
        Document document = null;
        PdfWriter writer = null;
        PdfContentByte cb = null;
        BufferedImage bi = null;
        if (output == Output.PDF) {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            document = new Document(rectangle);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            document.open();
            cb = writer.getDirectContent();
            cb.saveState();
            g2d = cb.createGraphics((float)width, (float)height);
        } else {
            bi = new BufferedImage(width, height, 1);
            g2d = bi.createGraphics();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.setFont(ROW_FONT);
        FontMetrics fontmetrics = g2d.getFontMetrics();
        int leftMargin = 0;
        for (String s : rowHeaders) {
            leftMargin = Math.max(leftMargin, fontmetrics.stringWidth(s));
        }
        leftMargin += 10;
        g2d.setFont(COL_FONT);
        fontmetrics = g2d.getFontMetrics();
        int topMargin = 0;
        for (String s : colHeaders) {
            topMargin = Math.max(topMargin, fontmetrics.stringWidth(s));
        }
        topMargin += 10;
        int plotWidth = width - leftMargin;
        int plotHeight = height - (topMargin += 200);
        int tileW = (int)((double)plotWidth) / values[0].length;
        int tileH = (int)((double)plotHeight) / values.length;
        if (tileW < 3) {
            throw new IllegalArgumentException("Map tiles would become less than 3 pixels wide (" + plotWidth + "/" + values[0].length + " = " + (double)plotWidth / (double)values[0].length + "). Output a wider image or use less columns.");
        }
        if (tileH < 3) {
            throw new IllegalArgumentException("Map tiles would become less than 3 pixels tall (" + plotHeight + "/" + values.length + " = " + (double)plotHeight / (double)values.length + "). Output a wider image or use less rows.");
        }
        g2d.setFont(ROW_FONT);
        g2d.setColor(Color.black);
        for (int row = 0; row < values.length; ++row) {
            g2d.drawString(rowHeaders[row], 0, topMargin + row * tileH + tileH / 2 + 5);
        }
        g2d.setFont(COL_FONT);
        g2d.setColor(Color.black);
        for (int col = 0; col < values[0].length; ++col) {
            g2d.rotate(-1.5707963267948966);
            g2d.drawString(colHeaders[col], -topMargin + 10, leftMargin + col * tileW + tileW / 2);
            g2d.rotate(1.5707963267948966);
        }
        double min = -1.0;
        double max = 1.0;
        Heatmap.normalizeCorrelations(values);
        for (int row = 0; row < values.length; ++row) {
            for (int col = 0; col < values[0].length; ++col) {
                g2d.setColor(Heatmap.getRGB(values[row][col]));
                g2d.fillRect(leftMargin + col * tileW, topMargin + row * tileH, tileW, tileH);
            }
        }
        int legendX = width - 200 - 20;
        GradientPaint gp = new GradientPaint(legendX, 10.0f, Color.blue, legendX + 100, 10.0f, Color.white);
        g2d.setPaint(gp);
        g2d.fillRect(legendX, 10, 100, 100);
        gp = new GradientPaint(legendX + 100, 10.0f, Color.white, legendX + 200, 10.0f, Color.red);
        g2d.setPaint(gp);
        g2d.fillRect(legendX + 100, 10, 100, 100);
        g2d.setColor(Color.black);
        g2d.setFont(LEGEND_FONT);
        String minStr = Math.round(min) + "";
        int stringWidth = fontmetrics.stringWidth(minStr);
        g2d.drawString(minStr, legendX - stringWidth / 2, 130);
        String avgStr = "0";
        stringWidth = fontmetrics.stringWidth(avgStr);
        g2d.drawString(avgStr, legendX + 100 - stringWidth / 2, 130);
        String maxStr = Math.round(max) + "";
        stringWidth = fontmetrics.stringWidth(maxStr);
        g2d.drawString(maxStr, legendX + 200 - stringWidth / 2, 130);
        g2d.dispose();
        if (output == Output.PDF) {
            cb.restoreState();
            document.close();
            writer.close();
        } else {
            bi.flush();
            ImageIO.write((RenderedImage)bi, output.toString().toLowerCase(), new File(filename));
        }
    }

    private static void normalize(double[][] values) {
        double min = ArrayMath.min((double[][])values);
        double max = ArrayMath.max((double[][])values) + min;
        System.out.println("Range: " + min + " -- " + max);
        for (int row = 0; row < values.length; ++row) {
            for (int col = 0; col < values[0].length; ++col) {
                double[] dArray = values[row];
                int n = col;
                dArray[n] = dArray[n] + min;
                double[] dArray2 = values[row];
                int n2 = col;
                dArray2[n2] = dArray2[n2] / max;
                System.out.println(values[row][col]);
            }
        }
        System.out.println("min " + ArrayMath.min((double[][])values));
        System.out.println("max " + ArrayMath.max((double[][])values));
    }

    private static void normalizeCorrelations(double[][] values) {
        for (int row = 0; row < values.length; ++row) {
            for (int col = 0; col < values[0].length; ++col) {
                values[row][col] = (values[row][col] + 1.0) / 2.0;
            }
        }
    }

    private Rectangle getScaleGradient(int width, int height) {
        Rectangle r = new Rectangle((float)width, (float)height);
        return r;
    }

    private static Color getRGB(double power) {
        if (power < 0.5) {
            return new Color((float)(power *= 2.0), (float)power, 1.0f);
        }
        power -= 0.5;
        return new Color(1.0f, (float)(1.0 - (power *= 2.0)), (float)(1.0 - power));
    }

    private static Color getColor(double power) {
        float h = (float)(power * 0.3);
        float s = 0.9f;
        float b = 0.9f;
        return Color.getHSBColor(h, s, b);
    }

    public static enum Output {
        PDF,
        PNG;

    }
}

