/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.genomicboundaries;

public class GenomicBoundary<V>
implements Comparable<GenomicBoundary> {
    private String chromosome;
    private Integer start;
    private int stop;
    private V annotation;

    public GenomicBoundary(String chromosome, Integer start, int stop) {
        this.chromosome = chromosome;
        this.start = start;
        this.stop = stop;
    }

    public GenomicBoundary(String chromosome, Integer start, int stop, V annotation) {
        this.chromosome = chromosome;
        this.start = start;
        this.stop = stop;
        this.annotation = annotation;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public Integer getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    @Override
    public int compareTo(GenomicBoundary other) {
        if (this.chromosome.equals(other.chromosome)) {
            if (this.start == other.start) {
                return other.stop - this.stop;
            }
            return this.start - other.start;
        }
        return this.chromosome.compareTo(other.chromosome);
    }

    public boolean isInBoundarie(int position) {
        return this.isInBoundarie(position, 0);
    }

    public boolean isInBoundarie(int position, int margin) {
        return position >= this.start - margin && position <= this.stop + margin;
    }

    public boolean isPartOfBoundary(GenomicBoundary other) {
        if (other == null) {
            return false;
        }
        return other.start <= this.start && other.stop >= this.stop;
    }

    public boolean isOverlaping(GenomicBoundary other) {
        if (other == null) {
            return false;
        }
        if (!this.chromosome.equals(other.chromosome)) {
            return false;
        }
        if (this.start <= other.start && this.stop >= other.start) {
            return true;
        }
        return other.start <= this.start && other.stop >= this.start;
    }

    public V getAnnotation() {
        return this.annotation;
    }

    public int getLength(boolean isInclusive) {
        if (isInclusive) {
            return this.getStop() + 1 - this.getStart();
        }
        return this.getStop() - this.getStart();
    }
}

