/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import org.broad.tribble.index.Block;

public class Interval
implements Comparable {
    final int start;
    final int end;
    private Block block;

    public Interval(int n, int n2) {
        assert (n <= n2);
        this.start = n;
        this.end = n2;
    }

    public Interval(int n, int n2, Block block) {
        assert (n <= n2);
        this.start = n;
        this.end = n2;
        this.block = block;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            Interval interval = (Interval)object;
            return this.start == interval.start && this.end == interval.end;
        }
        return false;
    }

    public int hashCode() {
        return this.start;
    }

    public int compareTo(Object object) {
        Interval interval = (Interval)object;
        if (this.start < interval.start) {
            return -1;
        }
        if (this.start > interval.start) {
            return 1;
        }
        if (this.end < interval.end) {
            return -1;
        }
        if (this.end > interval.end) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Interval[" + this.start + ", " + this.end + "]";
    }

    public boolean overlaps(Interval interval) {
        return this.start <= interval.end && interval.start <= this.end;
    }

    public Block getBlock() {
        return this.block;
    }
}

