/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.Iterator;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TabixFeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.TribbleIndexedFeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec codec;
    protected FeatureCodecHeader header;

    public static final AbstractFeatureReader getFeatureReader(String string, FeatureCodec featureCodec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(string, featureCodec, true);
    }

    public static final AbstractFeatureReader getFeatureReader(String string, FeatureCodec featureCodec, boolean bl) throws TribbleException {
        try {
            if (string.endsWith(".gz") && ParsingUtils.resourceExists(string + ".tbi")) {
                if (!(featureCodec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + featureCodec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(string, (AsciiFeatureCodec)featureCodec);
            }
            return new TribbleIndexedFeatureReader(string, featureCodec, bl);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", string, iOException);
        }
        catch (TribbleException tribbleException) {
            tribbleException.setSource(string);
            throw tribbleException;
        }
    }

    public static final AbstractFeatureReader getFeatureReader(String string, FeatureCodec featureCodec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader(string, featureCodec, index);
        }
        catch (IOException iOException) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", string, iOException);
        }
    }

    protected AbstractFeatureReader(String string, FeatureCodec featureCodec) {
        this.path = string;
        this.codec = featureCodec;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

