/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.IOException;
import java.net.URL;
import net.sf.samtools.seekablestream.SeekableFTPStreamHelper;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import net.sf.samtools.seekablestream.UserPasswordInput;

public class SeekableFTPStream
extends SeekableStream {
    SeekableFTPStreamHelper helper;
    private static final String EXPECTED1 = "\u00cf\u00ac\u00c9uC\u00d4\u00d5y";
    private static final String EXPECTED2 = "\u00e4lw\f\u0016\u00f10\u008f";

    public SeekableFTPStream(URL uRL) throws IOException {
        this(uRL, null);
    }

    public SeekableFTPStream(URL uRL, UserPasswordInput userPasswordInput) throws IOException {
        this.helper = new SeekableFTPStreamHelper(uRL, userPasswordInput);
    }

    @Override
    public void seek(long l) {
        this.helper.seek(l);
    }

    @Override
    public long position() {
        return this.helper.position();
    }

    @Override
    public boolean eof() throws IOException {
        return this.helper.eof();
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public long length() {
        return this.helper.length();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.helper.skip(l);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.helper.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.helper.close();
    }

    @Override
    public int read() throws IOException {
        return this.helper.read();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = stringArray.length < 1 ? "ftp://hgdownload.cse.ucsc.edu/goldenPath/panTro3/vsHg19/panTro3.hg19.all.chain.gz" : stringArray[0];
        long l = stringArray.length < 2 ? 11955320L : Long.parseLong(stringArray[1]);
        int n = stringArray.length < 3 ? 8 : Integer.parseInt(stringArray[2]);
        int n2 = stringArray.length < 4 ? 24 : Integer.parseInt(stringArray[3]);
        SeekableStream seekableStream = SeekableStreamFactory.getStreamFor(string);
        byte[] byArray = new byte[n];
        seekableStream.seek(l);
        seekableStream.read(byArray, 0, n);
        if (seekableStream.position() != l + (long)n && seekableStream.position() != seekableStream.length()) {
            System.out.println("1) updated position is incorrect");
        }
        String string2 = new String(byArray);
        System.out.println("1) read:" + string2);
        if (stringArray.length == 0) {
            System.out.println("1) expected:\u00cf\u00ac\u00c9uC\u00d4\u00d5y");
            System.out.println("1) values do" + (EXPECTED1.equals(string2) ? "" : " not") + " match");
        }
        seekableStream.skip(n2);
        seekableStream.read(byArray, 0, n);
        if (seekableStream.position() != l + (long)(2 * n) + (long)n2 && seekableStream.position() != seekableStream.length()) {
            System.out.println("2) updated position is incorrect");
        }
        String string3 = new String(byArray);
        System.out.println("2) read:" + string3);
        if (stringArray.length == 0) {
            System.out.println("2) expected:\u00e4lw\f\u0016\u00f10\u008f");
            System.out.println("2) values do" + (EXPECTED2.equals(string3) ? "" : " not") + " match");
        }
    }
}

