/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.EnumSet;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.picard.vcf.VariantContextUtils;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;

public class SplitVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Splits an input VCF file into two files, one for indel records and one for SNPs. The" + "headers of the two output files will be identical. An index file is created and a" + "sequence dictionary is required by default.";
    @Option(shortName="I", doc="The VCF input file")
    public File INPUT;
    @Option(doc="The VCF file to which SNP records should be written")
    public File SNP_OUTPUT;
    @Option(doc="The VCF file to which indel records should be written")
    public File INDEL_OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary (required if CREATE_INDEX=true)", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(SplitVcfs.class);

    public static void main(String[] stringArray) {
        new SplitVcfs().instanceMainWithExit(stringArray);
    }

    public SplitVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        VariantContextIterator variantContextIterator = new VariantContextIterator(this.INPUT);
        VCFHeader vCFHeader = variantContextIterator.getHeader();
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        SAMSequenceDictionary sAMSequenceDictionary = this.SEQUENCE_DICTIONARY != null ? VariantContextUtils.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : null;
        VariantContextWriter variantContextWriter = VariantContextUtils.getConditionallyCompressingWriter(this.SNP_OUTPUT, sAMSequenceDictionary, enumSet);
        VariantContextWriter variantContextWriter2 = VariantContextUtils.getConditionallyCompressingWriter(this.INDEL_OUTPUT, sAMSequenceDictionary, enumSet);
        variantContextWriter.writeHeader(vCFHeader);
        variantContextWriter2.writeHeader(vCFHeader);
        while (variantContextIterator.hasNext()) {
            VariantContext variantContext = variantContextIterator.next();
            if (variantContext.isIndel()) {
                variantContextWriter2.add(variantContext);
            } else if (variantContext.isSNP()) {
                variantContextWriter.add(variantContext);
            } else {
                throw new IllegalStateException("Found a record with type " + variantContext.getType().name());
            }
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        variantContextWriter.close();
        variantContextWriter2.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SEQUENCE_DICTIONARY == null) {
            return new String[]{"If CREATE_INDEX is set a sequence dictionary must be specified."};
        }
        return null;
    }
}

