/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.IntervalFilter;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.Interval;
import net.sf.picard.util.SamRecordIntervalIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;

public class SamRecordIntervalIteratorFactory {
    public CloseableIterator<SAMRecord> makeSamRecordIntervalIterator(SAMFileReader sAMFileReader, List<Interval> list, boolean bl) {
        IntervalFilter intervalFilter = new IntervalFilter(list, sAMFileReader.getFileHeader());
        if (!sAMFileReader.hasIndex() || !bl) {
            int n;
            int n2;
            if (list.isEmpty()) {
                n2 = -1;
                n = -1;
            } else {
                Interval interval = list.get(list.size() - 1);
                n2 = sAMFileReader.getFileHeader().getSequenceIndex(interval.getSequence());
                n = interval.getEnd();
            }
            return new StopAfterFilteringIterator(sAMFileReader.iterator(), intervalFilter, n2, n);
        }
        return new FilteringIterator(new SamRecordIntervalIterator(sAMFileReader, list), intervalFilter);
    }

    private class StopAfterFilteringIterator
    implements CloseableIterator<SAMRecord> {
        private final int stopAfterSequence;
        private final int stopAfterPosition;
        private final Iterator<SAMRecord> iterator;
        private final SamRecordFilter filter;
        private SAMRecord next = null;

        private StopAfterFilteringIterator(Iterator<SAMRecord> iterator, SamRecordFilter samRecordFilter, int n, int n2) {
            this.stopAfterSequence = n;
            this.stopAfterPosition = n2;
            this.iterator = iterator;
            this.filter = samRecordFilter;
            this.next = this.getNextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SAMRecord next() {
            if (this.next == null) {
                throw new NoSuchElementException("Iterator has no more elements.");
            }
            SAMRecord sAMRecord = this.next;
            this.next = this.getNextRecord();
            return sAMRecord;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove() not supported by FilteringIterator");
        }

        @Override
        public void close() {
            CloserUtil.close(this.iterator);
        }

        protected SAMRecord getNextRecord() {
            while (this.iterator.hasNext()) {
                SAMRecord sAMRecord = this.iterator.next();
                if (sAMRecord.getReferenceIndex() == -1) {
                    return null;
                }
                if (sAMRecord.getReferenceIndex() > this.stopAfterSequence) {
                    return null;
                }
                if (sAMRecord.getReferenceIndex() == this.stopAfterSequence && sAMRecord.getAlignmentStart() > this.stopAfterPosition) {
                    return null;
                }
                if (this.filter.filterOut(sAMRecord)) continue;
                return sAMRecord;
            }
            return null;
        }
    }
}

