/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sf.picard.PicardException;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class ProcessExecutor {
    private static final Log log = Log.getInstance(ProcessExecutor.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "ProcessExecutor Thread");
        }
    });

    public static int execute(String string) {
        try {
            Process process = Runtime.getRuntime().exec(string);
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", string) + "]", throwable);
        }
    }

    public static int execute(String[] stringArray) {
        return ProcessExecutor.execute(stringArray, null);
    }

    public static int execute(String[] stringArray, String string) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            if (string != null) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", stringArray) + "]", throwable);
        }
    }

    public static String executeAndReturnResult(String string) {
        try {
            Process process = Runtime.getRuntime().exec(string);
            StringBuilderProcessOutputReader stringBuilderProcessOutputReader = new StringBuilderProcessOutputReader(process.getErrorStream());
            Future<?> future = executorService.submit(stringBuilderProcessOutputReader);
            StringBuilderProcessOutputReader stringBuilderProcessOutputReader2 = new StringBuilderProcessOutputReader(process.getInputStream());
            stringBuilderProcessOutputReader2.run();
            future.get();
            int n = process.waitFor();
            return n == 0 ? stringBuilderProcessOutputReader2.getOutput() : stringBuilderProcessOutputReader.getOutput();
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + string + "]", throwable);
        }
    }

    private static int readStreamsAndWaitFor(Process process) throws InterruptedException, ExecutionException {
        Future<?> future = executorService.submit(new LogErrorProcessOutputReader(process.getErrorStream()));
        new LogInfoProcessOutputReader(process.getInputStream()).run();
        future.get();
        return process.waitFor();
    }

    private static class StringBuilderProcessOutputReader
    extends ProcessOutputReader {
        private final StringBuilder sb = new StringBuilder();

        public StringBuilderProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string) {
            this.sb.append(string).append("\n");
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }

    private static class LogInfoProcessOutputReader
    extends ProcessOutputReader {
        public LogInfoProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string) {
            log.info(string);
        }
    }

    private static class LogErrorProcessOutputReader
    extends ProcessOutputReader {
        public LogErrorProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string) {
            log.error(string);
        }
    }

    private static abstract class ProcessOutputReader
    implements Runnable {
        private final BufferedReader reader;

        public ProcessOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.reader.readLine()) != null) {
                    this.write(string);
                }
            }
            catch (IOException iOException) {
                throw new PicardException("Unexpected exception reading from process stream", iOException);
            }
        }

        protected abstract void write(String var1);
    }
}

