/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.BitSet;
import java.util.List;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ReferenceSequenceMask;
import net.sf.samtools.SAMFileHeader;

public class IntervalListReferenceSequenceMask
implements ReferenceSequenceMask {
    private final SAMFileHeader header;
    private final BitSet currentBitSet = new BitSet();
    private int currentSequenceIndex = -1;
    private final PeekableIterator<Interval> intervalIterator;
    private final int lastSequenceIndex;
    private final int lastPosition;

    public IntervalListReferenceSequenceMask(IntervalList intervalList) {
        List<Interval> list;
        this.header = intervalList.getHeader();
        if (intervalList.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            intervalList.sort();
        }
        if ((list = intervalList.getUniqueIntervals()).isEmpty()) {
            this.lastSequenceIndex = -1;
            this.lastPosition = 0;
        } else {
            Interval interval = list.get(list.size() - 1);
            this.lastSequenceIndex = this.header.getSequenceIndex(interval.getSequence());
            this.lastPosition = interval.getEnd();
        }
        this.intervalIterator = new PeekableIterator<Interval>(list.iterator());
    }

    @Override
    public boolean get(int n, int n2) {
        this.ensureSequenceLoaded(n);
        return this.currentBitSet.get(n2);
    }

    @Override
    public int nextPosition(int n, int n2) {
        this.ensureSequenceLoaded(n);
        return this.currentBitSet.nextSetBit(n2);
    }

    private void ensureSequenceLoaded(int n) {
        if (n < this.currentSequenceIndex) {
            throw new IllegalArgumentException("Cannot look at an earlier sequence.  Current: " + this.currentSequenceIndex + "; requested: " + n);
        }
        if (n > this.currentSequenceIndex) {
            this.currentBitSet.clear();
            while (this.intervalIterator.hasNext()) {
                Interval interval = this.intervalIterator.peek();
                int n2 = this.header.getSequenceIndex(interval.getSequence());
                if (n2 < n) {
                    this.intervalIterator.next();
                    continue;
                }
                if (n2 != n) break;
                this.currentBitSet.set(interval.getStart(), interval.getEnd() + 1);
                this.intervalIterator.next();
            }
            this.currentSequenceIndex = n;
        }
    }

    @Override
    public int getMaxSequenceIndex() {
        return this.lastSequenceIndex;
    }

    @Override
    public int getMaxPosition() {
        return this.lastPosition;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }
}

