/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.illumina.parser.readers.TileMetricsOutReader;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.util.StringUtil;

public class IlluminaFileUtil {
    private final File dataDir;
    private final File intensityDir;
    private final File intensityLaneDir;
    private final File basecallDir;
    private final File basecallLaneDir;
    private final File interopDir;
    private final int lane;
    private final String QSeqRegex = "s_(\\d+)_(\\d)_(\\d{4}).qseq.txt";
    private final QSeqIlluminaFileUtil qseq;
    private final PerTilePerCycleFileUtil bcl;
    private final PerTilePerCycleFileUtil cif;
    private final PerTilePerCycleFileUtil cnf;
    private final PerTileFileUtil pos;
    private final PerTileFileUtil locs;
    private final PerTileFileUtil clocs;
    private final PerTileFileUtil filter;
    private final PerTileFileUtil barcode;
    private final File tileMetricsOut;
    private final Map<SupportedIlluminaFormat, ParameterizedFileUtil> utils;
    public static String UNPARAMETERIZED_PER_TILE_PATTERN = "s_(\\d+)_(\\d{1,4})";
    public static String UNPARAMETERIZED_QSEQ_PATTERN = "s_(\\d+)_(\\d)_(\\d{4})_qseq\\.txt(\\.gz|\\.bz2)?";
    private static String LANE_TILE_QSEQ_PATTERN = "s_(\\d+)_\\d_(\\d{4})_qseq\\.txt(\\.gz|\\.bz2)?";
    private static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("^C(\\d+)\\.1$");

    public IlluminaFileUtil(File file, int n) {
        this.basecallDir = file;
        this.intensityDir = file.getParentFile();
        this.dataDir = this.intensityDir.getParentFile();
        this.lane = n;
        this.basecallLaneDir = new File(file, IlluminaFileUtil.longLaneStr(n));
        this.intensityLaneDir = new File(this.intensityDir, IlluminaFileUtil.longLaneStr(n));
        this.interopDir = new File(this.dataDir.getParentFile(), "InterOp");
        this.utils = new HashMap<SupportedIlluminaFormat, ParameterizedFileUtil>();
        this.qseq = new QSeqIlluminaFileUtil();
        this.utils.put(SupportedIlluminaFormat.Qseq, this.qseq);
        this.bcl = new PerTilePerCycleFileUtil(".bcl", this.basecallLaneDir);
        this.utils.put(SupportedIlluminaFormat.Bcl, this.bcl);
        this.cif = new PerTilePerCycleFileUtil(".cif");
        this.utils.put(SupportedIlluminaFormat.Cif, this.cif);
        this.cnf = new PerTilePerCycleFileUtil(".cnf");
        this.utils.put(SupportedIlluminaFormat.Cnf, this.cnf);
        this.locs = new PerTileFileUtil(".locs", false);
        this.utils.put(SupportedIlluminaFormat.Locs, this.locs);
        this.clocs = new PerTileFileUtil(".clocs", false);
        this.utils.put(SupportedIlluminaFormat.Clocs, this.clocs);
        this.pos = new PerTileFileUtil("_pos.txt", false, this.intensityDir);
        this.utils.put(SupportedIlluminaFormat.Pos, this.pos);
        this.filter = new PerTileFileUtil(".filter", true, this.basecallLaneDir);
        this.utils.put(SupportedIlluminaFormat.Filter, this.filter);
        this.barcode = new PerTileFileUtil("_barcode.txt", true, file);
        this.utils.put(SupportedIlluminaFormat.Barcode, this.barcode);
        this.tileMetricsOut = new File(this.interopDir, "TileMetricsOut.bin");
    }

    public int getLane() {
        return this.lane;
    }

    public ParameterizedFileUtil getUtil(SupportedIlluminaFormat supportedIlluminaFormat) {
        return this.utils.get((Object)supportedIlluminaFormat);
    }

    public List<Integer> getExpectedTiles() {
        IoUtil.assertFileIsReadable(this.tileMetricsOut);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TileMetricsOutReader tileMetricsOutReader = new TileMetricsOutReader(this.tileMetricsOut);
        while (tileMetricsOutReader.hasNext()) {
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics = (TileMetricsOutReader.IlluminaTileMetrics)tileMetricsOutReader.next();
            if (illuminaTileMetrics.getLaneNumber() != this.lane || treeSet.contains(illuminaTileMetrics.getTileNumber())) continue;
            treeSet.add(illuminaTileMetrics.getTileNumber());
        }
        return new ArrayList<Integer>(treeSet);
    }

    public List<Integer> getActualTiles(List<SupportedIlluminaFormat> list) {
        if (list == null) {
            throw new PicardException("Format list provided to getTiles was null!");
        }
        if (list.size() == 0) {
            throw new PicardException("0 Formats were specified.  You need to specify at least SupportedIlluminaFormat to use getTiles");
        }
        List<Integer> list2 = this.utils.get((Object)list.get(0)).getTiles();
        for (int i = 0; i < list.size(); ++i) {
            List<Integer> list3 = this.utils.get((Object)list.get(i)).getTiles();
            if (list2.size() == list3.size() && list2.containsAll(list3)) continue;
            throw new PicardException("Formats do not have the same number of tiles! " + this.summarizeTileCounts(list));
        }
        return list2;
    }

    public QSeqIlluminaFileUtil qseq() {
        return this.qseq;
    }

    public PerTilePerCycleFileUtil bcl() {
        return this.bcl;
    }

    public PerTilePerCycleFileUtil cif() {
        return this.cif;
    }

    public PerTilePerCycleFileUtil cnf() {
        return this.cnf;
    }

    public PerTileFileUtil locs() {
        return this.locs;
    }

    public PerTileFileUtil clocs() {
        return this.clocs;
    }

    public PerTileFileUtil pos() {
        return this.pos;
    }

    public PerTileFileUtil filter() {
        return this.filter;
    }

    public PerTileFileUtil barcode() {
        return this.barcode;
    }

    public File tileMetricsOut() {
        return this.tileMetricsOut;
    }

    public static String makeParameterizedLaneAndTileRegex(int n) {
        if (n < 0) {
            throw new PicardException("Lane (" + n + ") cannot be negative");
        }
        return "s_" + n + "_(\\d{1,4})";
    }

    public static String makeParameterizedQseqRegex(int n) {
        if (n < 0) {
            throw new PicardException("Lane (" + n + ") cannot be negative");
        }
        return "s_" + n + "_(\\d)_(\\d{4})_qseq\\.txt(\\.gz|\\.bz2)?";
    }

    public static String makeLTRegex(String string) {
        return "^" + UNPARAMETERIZED_PER_TILE_PATTERN + string + "$";
    }

    private static String makeLTRegex(String string, int n) {
        return "^" + IlluminaFileUtil.makeParameterizedLaneAndTileRegex(n) + string + "$";
    }

    private static int getCycleFromDir(File file) {
        char[] cArray = file.getName().toCharArray();
        if (cArray[0] != 'C') {
            throw new PicardException("Invalid cycle directory name " + file.getName());
        }
        String string = "";
        boolean bl = false;
        for (int i = 1; i < cArray.length && !bl; ++i) {
            if (cArray[i] == '.') {
                bl = true;
                continue;
            }
            if (cArray[i] == '1' || cArray[i] == '2' || cArray[i] == '3' || cArray[i] == '4' || cArray[i] == '5' || cArray[i] == '6' || cArray[i] == '7' || cArray[i] == '8' || cArray[i] == '9' || cArray[i] == '0') {
                string = string + cArray[i];
                continue;
            }
            throw new PicardException("Invalid cycle directory name " + file.getAbsolutePath());
        }
        return Integer.parseInt(string);
    }

    private static LaneTileEnd laneAndTileFromFirstTwoMatches(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new LaneTileEnd(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    private static String longLaneStr(int n) {
        String string = String.valueOf(n);
        int n2 = 3 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return "L" + string;
    }

    private static String longTileStr(int n) {
        String string = String.valueOf(n);
        int n2 = 4 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private static IlluminaFileMap getTiledFiles(File file, Pattern pattern, ParameterizedFileUtil parameterizedFileUtil) {
        IlluminaFileMap illuminaFileMap = new IlluminaFileMap();
        if (file.exists()) {
            File[] fileArray;
            IoUtil.assertDirectoryIsReadable(file);
            for (File file2 : fileArray = IoUtil.getFilesMatchingRegexp(file, pattern)) {
                if (file2.length() <= 0L) continue;
                LaneTileEnd laneTileEnd = parameterizedFileUtil.fileToLaneTileEnd(file2.getName());
                illuminaFileMap.put(laneTileEnd.tile, file2);
            }
        }
        return illuminaFileMap;
    }

    private static String processTxtExtension(String string) {
        if (string.endsWith(".txt")) {
            return string + "(\\.gz|\\.bz2)?";
        }
        return string;
    }

    private String liToStr(List<Integer> list) {
        if (list.size() == 0) {
            return "";
        }
        String string = String.valueOf(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            string = string + ", " + String.valueOf(list.get(i));
        }
        return string;
    }

    private String summarizeTileCounts(List<SupportedIlluminaFormat> list) {
        ParameterizedFileUtil parameterizedFileUtil = this.utils.get((Object)list.get(0));
        List<Integer> list2 = parameterizedFileUtil.getTiles();
        String string = parameterizedFileUtil.extension + "(" + this.liToStr(list2) + ")";
        for (int i = 0; i < list.size(); ++i) {
            parameterizedFileUtil = this.utils.get((Object)list.get(i));
            list2 = parameterizedFileUtil.getTiles();
            string = string + ", " + parameterizedFileUtil.extension + "(" + this.liToStr(list2) + ")";
        }
        return string;
    }

    static class LaneTileEnd {
        public final Integer lane;
        public final Integer tile;
        public final Integer end;

        public LaneTileEnd(Integer n, Integer n2, Integer n3) {
            this.lane = n;
            this.tile = n2;
            this.end = n3;
        }

        public LaneTileEnd(Integer n, Integer n2) {
            this(n, n2, null);
        }
    }

    class QSeqIlluminaFileUtil
    extends ParameterizedFileUtil {
        private final List<Integer> tiles;
        private final List<IlluminaFileMap> readFileMaps;

        public QSeqIlluminaFileUtil() {
            super(UNPARAMETERIZED_QSEQ_PATTERN, IlluminaFileUtil.makeParameterizedQseqRegex(IlluminaFileUtil.this.lane), "_qseq.txt", IlluminaFileUtil.this.basecallDir);
            this.readFileMaps = this.getFiles();
            this.tiles = this.readFileMaps.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.readFileMaps.get(0).keySet())) : new ArrayList<Integer>();
        }

        private String makeLaneAndEndSpecificRegex(int n, int n2) {
            return "^s_" + n + "_" + n2 + "_\\d{4}_qseq\\.txt(\\.gz|\\.bz2)?$";
        }

        public int numberOfEnds() {
            return this.readFileMaps.size();
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String string) {
            Matcher matcher = this.unparameterizedPattern.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            return new LaneTileEnd(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(2)));
        }

        private IlluminaFileMap getFiles(int n) {
            String string = this.makeLaneAndEndSpecificRegex(IlluminaFileUtil.this.lane, n);
            return IlluminaFileUtil.getTiledFiles(IlluminaFileUtil.this.basecallDir, Pattern.compile(string), this);
        }

        public List<IlluminaFileMap> getFiles() {
            ArrayList<IlluminaFileMap> arrayList = new ArrayList<IlluminaFileMap>();
            boolean bl = false;
            int n = 1;
            while (!bl) {
                IlluminaFileMap illuminaFileMap = this.getFiles(n);
                if (illuminaFileMap.isEmpty()) {
                    bl = true;
                } else {
                    arrayList.add(illuminaFileMap);
                }
                ++n;
            }
            return arrayList;
        }

        public List<IlluminaFileMap> getFiles(List<Integer> list) {
            ArrayList<IlluminaFileMap> arrayList = new ArrayList<IlluminaFileMap>();
            for (IlluminaFileMap illuminaFileMap : this.readFileMaps) {
                arrayList.add(illuminaFileMap.keep(list));
            }
            return arrayList;
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public List<String> verify(List<Integer> list, int[] nArray) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!this.base.exists()) {
                linkedList.add("Base directory( " + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                int n;
                Object object;
                List<IlluminaFileMap> list2 = this.getFiles(list);
                int[] nArray2 = new int[this.numberOfEnds()];
                int n2 = 0;
                for (int i = 0; i < nArray2.length; ++i) {
                    object = (File)list2.get(i).get(list.get(0));
                    nArray2[i] = QseqReadParser.getReadLength((File)object);
                    n2 += nArray2[i];
                }
                Range range = new Range(1, n2);
                object = nArray;
                int n3 = ((int[])object).length;
                for (n = 0; n < n3; ++n) {
                    int n4 = object[n];
                    if (n4 >= range.start && n4 <= range.end) continue;
                    linkedList.add("Expected cycle(" + n4 + ") is not within the range provided by available qseqs.  " + "Min Available Cycle(" + range.start + ") Max Available Cycle(" + range.end + ") Length of Qseqs( " + StringUtil.join(", ", new int[][]{nArray2}));
                }
                for (int i = 1; i < list.size(); ++i) {
                    Integer n5 = list.get(i);
                    for (n = 0; n < nArray2.length; ++n) {
                        File file = (File)list2.get(n).get(n5);
                        if (file != null && file.exists()) continue;
                        linkedList.add("Missing file s_" + IlluminaFileUtil.this.lane + "_" + (n + 1) + "_" + IlluminaFileUtil.longTileStr(n5) + "_qseq.txt");
                    }
                }
            }
            return linkedList;
        }

        @Override
        public boolean filesAvailable() {
            return !this.tiles.isEmpty();
        }
    }

    class PerTilePerCycleFileUtil
    extends ParameterizedFileUtil {
        private final CycleIlluminaFileMap cycleFileMap;
        private List<Integer> tiles;
        private int[] detectedCycles;

        public PerTilePerCycleFileUtil(String string, File file) {
            super(IlluminaFileUtil.makeLTRegex(string), IlluminaFileUtil.makeLTRegex(string, IlluminaFileUtil.this.lane), string, file);
            this.cycleFileMap = this.getPerTilePerCycleFiles();
            this.tiles = this.cycleFileMap.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.cycleFileMap.keySet())) : new ArrayList<Integer>();
        }

        public PerTilePerCycleFileUtil(String string) {
            this(string, illuminaFileUtil.intensityLaneDir);
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String string) {
            return IlluminaFileUtil.laneAndTileFromFirstTwoMatches(string, this.unparameterizedPattern);
        }

        private List<Integer> getTilesInCycleDir(File file) {
            File[] fileArray = IoUtil.getFilesMatchingRegexp(file, this.pattern);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (File file2 : fileArray) {
                if (file2.length() <= 0L) continue;
                arrayList.add(this.fileToLaneTileEnd((String)file2.getName()).tile);
            }
            return arrayList;
        }

        private CycleIlluminaFileMap getPerTilePerCycleFiles() {
            CycleIlluminaFileMap cycleIlluminaFileMap = new CycleIlluminaFileMap();
            File file = this.base;
            File file2 = null;
            File[] fileArray = IoUtil.getFilesMatchingRegexp(file, CYCLE_SUBDIRECTORY_PATTERN);
            if (fileArray == null || fileArray.length == 0) {
                return cycleIlluminaFileMap;
            }
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            int[] nArray = new int[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                nArray[i] = IlluminaFileUtil.getCycleFromDir(fileArray[i]);
                if (nArray[i] >= n) continue;
                n = nArray[i];
                n2 = i;
            }
            file2 = fileArray[n2];
            Arrays.sort(nArray);
            this.detectedCycles = nArray;
            List<Integer> list = this.getTilesInCycleDir(file2);
            for (int n3 : list) {
                cycleIlluminaFileMap.put(n3, new CycleFilesIterator(file, IlluminaFileUtil.this.lane, n3, nArray, this.extension));
            }
            return cycleIlluminaFileMap;
        }

        public CycleIlluminaFileMap getFiles() {
            return this.cycleFileMap;
        }

        public CycleIlluminaFileMap getFiles(List<Integer> list) {
            return this.cycleFileMap.keep(list, null);
        }

        public CycleIlluminaFileMap getFiles(int[] nArray) {
            int[] nArray2 = this.removeNonexistantCycles(nArray);
            return this.cycleFileMap.keep(null, nArray2);
        }

        public CycleIlluminaFileMap getFiles(List<Integer> list, int[] nArray) {
            int[] nArray2 = this.removeNonexistantCycles(nArray);
            return this.cycleFileMap.keep(list, nArray2);
        }

        private int[] removeNonexistantCycles(int[] nArray) {
            Integer n;
            int n2;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Object object = this.detectedCycles;
            int n3 = ((int[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                Integer n4 = object[n2];
                treeSet.add(n4);
            }
            object = new TreeSet();
            int[] nArray2 = nArray;
            n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                n = nArray2[i];
                ((TreeSet)object).add(n);
            }
            ((AbstractCollection)object).retainAll(treeSet);
            nArray2 = new int[((TreeSet)object).size()];
            n2 = 0;
            Iterator iterator = ((TreeSet)object).iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                nArray2[n2++] = n;
            }
            return nArray2;
        }

        public int[] getDetectedCycles() {
            return this.detectedCycles;
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public boolean filesAvailable() {
            return !this.cycleFileMap.isEmpty();
        }

        @Override
        public List<String> verify(List<Integer> list, int[] nArray) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!this.base.exists()) {
                linkedList.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                int n;
                CycleIlluminaFileMap cycleIlluminaFileMap = this.getFiles(list, nArray);
                HashSet<Integer> hashSet = new HashSet<Integer>();
                Object object = this.detectedCycles;
                int n2 = ((int[])object).length;
                for (n = 0; n < n2; ++n) {
                    Integer n3 = object[n];
                    hashSet.add(n3);
                }
                object = new TreeSet();
                Object object2 = nArray;
                n = ((int[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Integer n4 = object2[i];
                    object.add(n4);
                }
                object.removeAll(hashSet);
                object2 = list.iterator();
                while (object2.hasNext()) {
                    Integer n5 = (Integer)object2.next();
                    CycleFilesIterator cycleFilesIterator = (CycleFilesIterator)cycleIlluminaFileMap.get(n5);
                    if (cycleFilesIterator == null) {
                        linkedList.add("File type " + this.extension + " is missing tile " + n5);
                        continue;
                    }
                    if (!cycleFilesIterator.hasNext()) {
                        linkedList.add("File type " + this.extension + " has 0 cycle files for tile " + n5);
                        continue;
                    }
                    Long l = null;
                    for (int i = 0; cycleFilesIterator.hasNext() && i < nArray.length; ++i) {
                        int n6 = nArray[i];
                        if (cycleFilesIterator.getNextCycle() == n6) {
                            File file = cycleFilesIterator.next();
                            if (!object.contains(n6)) {
                                if (!file.exists()) {
                                    linkedList.add("Missing file(" + file.getAbsolutePath() + ")");
                                    continue;
                                }
                                if (file.length() == 0L) {
                                    linkedList.add("0 Length tile file(" + file.getAbsolutePath() + ")");
                                    continue;
                                }
                                if (l == null) {
                                    l = file.length();
                                    continue;
                                }
                                if (l.longValue() == file.length()) continue;
                                linkedList.add("File type " + this.extension + " has cycles files of different length.  Current cycle (" + n6 + ") " + "Length of first non-empty file (" + l + ") length of current cycle (" + file.length() + ")" + " File(" + file.getAbsolutePath() + ")");
                                continue;
                            }
                            cycleFilesIterator.reset();
                            throw new PicardException("Malformed CycleIlluminaFileMap! CycleIlluminaFileMap has cycle " + n6 + " even though the directory does not exist!  CycleFileIterator(" + CycleIlluminaFileMap.remainingCyclesToString(cycleFilesIterator) + ")");
                        }
                        if (object.contains(n6)) continue;
                        cycleFilesIterator.reset();
                        throw new PicardException("Malformed CycleIlluminaFileMap! Tile " + n5 + "CycleFileIterator(" + CycleIlluminaFileMap.remainingCyclesToString(cycleFilesIterator) + ")");
                    }
                }
                object2 = object.iterator();
                while (object2.hasNext()) {
                    Integer n7 = (Integer)object2.next();
                    linkedList.add("Missing cycle directory " + n7 + " in directory " + this.base.getAbsolutePath() + " for file type " + this.extension);
                }
            }
            return linkedList;
        }
    }

    class PerTileFileUtil
    extends ParameterizedFileUtil {
        protected final boolean txtBased;
        protected final boolean padTile;
        protected final IlluminaFileMap fileMap;
        protected final List<Integer> tiles;

        public PerTileFileUtil(String string, boolean bl, File file) {
            super(IlluminaFileUtil.makeLTRegex(IlluminaFileUtil.processTxtExtension(string)), IlluminaFileUtil.makeLTRegex(IlluminaFileUtil.processTxtExtension(string), IlluminaFileUtil.this.lane), string, file);
            this.txtBased = string.endsWith(".txt");
            this.padTile = bl;
            this.fileMap = IlluminaFileUtil.getTiledFiles(file, this.pattern, this);
            this.tiles = this.fileMap.size() > 0 ? Collections.unmodifiableList(new ArrayList(this.fileMap.keySet())) : new ArrayList<Integer>();
        }

        public PerTileFileUtil(String string, boolean bl) {
            this(string, bl, illuminaFileUtil.intensityLaneDir);
        }

        @Override
        public boolean filesAvailable() {
            return !this.fileMap.isEmpty();
        }

        @Override
        public LaneTileEnd fileToLaneTileEnd(String string) {
            return IlluminaFileUtil.laneAndTileFromFirstTwoMatches(string, this.unparameterizedPattern);
        }

        public IlluminaFileMap getFiles() {
            return this.fileMap;
        }

        public IlluminaFileMap getFiles(List<Integer> list) {
            return this.fileMap.keep(list);
        }

        @Override
        public List<Integer> getTiles() {
            return this.tiles;
        }

        @Override
        public List<String> verify(List<Integer> list, int[] nArray) {
            LinkedList<String> linkedList = new LinkedList<String>();
            if (!this.base.exists()) {
                linkedList.add("Base directory(" + this.base.getAbsolutePath() + ") does not exist!");
            } else {
                for (Integer n : list) {
                    if (!this.tiles.contains(n)) {
                        linkedList.add("Missing tile " + n + " for file type " + this.extension + ".");
                        continue;
                    }
                    if (((File)this.fileMap.get(n)).length() != 0L) continue;
                    linkedList.add("Tile " + n + " is empty for file type " + this.extension + ".");
                }
            }
            return linkedList;
        }
    }

    public abstract class ParameterizedFileUtil {
        public final String extension;
        public final Pattern pattern;
        public final Pattern unparameterizedPattern;
        protected final File base;

        public ParameterizedFileUtil(String string, String string2, String string3, File file) {
            this.pattern = Pattern.compile(this.escapePeriods(string2));
            this.unparameterizedPattern = Pattern.compile(this.escapePeriods(string));
            this.extension = string3;
            this.base = file;
        }

        private String escapePeriods(String string) {
            return string.replaceAll("\\.", "\\.");
        }

        public abstract boolean filesAvailable();

        public abstract LaneTileEnd fileToLaneTileEnd(String var1);

        public abstract List<Integer> getTiles();

        public abstract List<String> verify(List<Integer> var1, int[] var2);
    }

    public static enum SupportedIlluminaFormat {
        Qseq,
        Bcl,
        Cif,
        Cnf,
        Locs,
        Clocs,
        Pos,
        Filter,
        Barcode;

    }
}

