/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.tuple;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.molgenis.util.tuple.AbstractTuple;

public class HttpServletRequestTuple
extends AbstractTuple {
    private static final Logger logger = Logger.getLogger(HttpServletRequestTuple.class);
    private static final long serialVersionUID = 1L;
    private final transient HttpServletRequest request;
    private final transient HttpServletResponse response;
    private boolean isMultipartRequest;
    private Map<String, Object> multipartParams;
    private int fileCtr = 0;
    private String previousFieldName = "";

    public HttpServletRequestTuple(HttpServletRequest request) throws IOException {
        this(request, null);
    }

    public HttpServletRequestTuple(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        this.request = request;
        this.response = response;
        this.isMultipartRequest = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (this.isMultipartRequest) {
            this.multipartParams = new HashMap<String, Object>();
            this.parseMultipartContentRequest();
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public int getNrCols() {
        return this.isMultipartRequest ? this.multipartParams.size() : this.request.getParameterMap().size();
    }

    @Override
    public Iterable<String> getColNames() {
        return this.isMultipartRequest ? this.multipartParams.keySet() : this.request.getParameterMap().keySet();
    }

    @Override
    public Object get(String colName) {
        return this.isMultipartRequest ? this.multipartParams.get(colName) : this.request.getParameter(colName);
    }

    @Override
    public Object get(int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getList(String colName) {
        if (this.isMultipartRequest) {
            Object multipartParam = this.multipartParams.get(colName);
            if (multipartParam instanceof List) {
                return (List)multipartParam;
            }
            if (multipartParam instanceof String) {
                return Collections.singletonList((String)multipartParam);
            }
        }
        return null;
    }

    @Override
    public List<String> getList(int col) {
        throw new UnsupportedOperationException();
    }

    public File getFile(String fileName) {
        return this.isMultipartRequest ? (File)this.multipartParams.get(fileName) : null;
    }

    private void parseMultipartContentRequest() throws IOException {
        List multipart;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        logger.debug((Object)("Current upload max size: " + upload.getSizeMax()));
        upload.setSizeMax(Long.MAX_VALUE);
        try {
            multipart = upload.parseRequest(this.request);
        }
        catch (FileUploadException e) {
            logger.warn((Object)e);
            throw new IOException(e);
        }
        for (int i = 0; i < multipart.size(); ++i) {
            FileItem item = (FileItem)multipart.get(i);
            if (item.isFormField()) {
                this.getFormFieldValues(multipart, i, item);
                continue;
            }
            this.getAttachedFileValues(item);
        }
    }

    private void getAttachedFileValues(FileItem item) throws IOException {
        if (item.getSize() != 0L) {
            String fileNumber;
            String filename = item.getName();
            if (item.getFieldName().equals(this.previousFieldName)) {
                ++this.fileCtr;
                fileNumber = Integer.toString(this.fileCtr);
            } else {
                fileNumber = "";
                this.fileCtr = 0;
            }
            this.previousFieldName = item.getFieldName();
            String extension = "text";
            if (filename.lastIndexOf(46) > 0) {
                extension = filename.substring(filename.lastIndexOf(46));
            }
            File uploadedFile = File.createTempFile("molgenis", extension);
            try {
                item.write(uploadedFile);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.multipartParams.put(item.getFieldName() + fileNumber, uploadedFile);
            this.multipartParams.put(item.getFieldName() + fileNumber + "OriginalFileName", filename);
        }
    }

    private void getFormFieldValues(List<?> multipart, int i, FileItem item) {
        int j;
        String name = item.getFieldName();
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(item.getString());
        for (j = i + 1; j < multipart.size(); ++j) {
            FileItem item2 = (FileItem)multipart.get(j);
            if (!item2.getFieldName().equals(name)) continue;
            elements.add(item2.getString());
            multipart.remove(j--);
        }
        if (elements.size() == 1) {
            if (item.getString().isEmpty()) {
                this.multipartParams.put(item.getFieldName(), null);
            } else {
                this.multipartParams.put(item.getFieldName(), item.getString());
            }
        } else {
            for (j = 0; j < elements.size(); ++j) {
                if (elements.get(j) != null && !((String)elements.get(j)).isEmpty()) continue;
                elements.remove(j);
            }
            this.multipartParams.put(item.getFieldName(), elements);
        }
    }
}

