/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.tuple;

import java.util.Vector;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.AbstractTuple;

public class EntityTuple
extends AbstractTuple {
    private static final long serialVersionUID = 1L;
    private final Entity entity;
    private transient Vector<String> cachedFields;

    public EntityTuple(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        this.entity = entity;
    }

    @Override
    public int getNrCols() {
        return this.getFields().size();
    }

    @Override
    public Iterable<String> getColNames() {
        return this.getFields();
    }

    @Override
    public Object get(String colName) {
        return this.entity.get(colName);
    }

    @Override
    public Object get(int col) {
        String colName = this.getFields().get(col);
        return this.get(colName);
    }

    private Vector<String> getFields() {
        if (this.cachedFields == null) {
            this.cachedFields = this.entity.getFields();
        }
        return this.cachedFields;
    }
}

