/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.trityper.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.molgenis.util.trityper.reader.SNP;

public class SNPLoader {
    private RandomAccessFile m_genotypehandle;
    private RandomAccessFile m_dosagehandle;
    private int m_numIndividuals;
    private final Boolean[] m_isIncluded;
    private final Boolean[] m_isFemale;

    public SNPLoader(RandomAccessFile genotypehandle, Boolean[] indIsIncluded, Boolean[] isFemale) {
        this.m_genotypehandle = genotypehandle;
        this.m_isIncluded = indIsIncluded;
        this.m_isFemale = isFemale;
    }

    public SNPLoader(RandomAccessFile genotypehandle, RandomAccessFile dosagehandle, Boolean[] indIsIncluded, Boolean[] isFemale) {
        this.m_genotypehandle = genotypehandle;
        this.m_dosagehandle = dosagehandle;
        this.m_isIncluded = indIsIncluded;
        this.m_isFemale = isFemale;
    }

    public void loadGenotypes(SNP snp) {
        byte[] allele1 = new byte[this.m_numIndividuals];
        byte[] allele2 = new byte[this.m_numIndividuals];
        int bytesize = this.m_numIndividuals * 2;
        long seekLoc = (long)snp.getId() * (long)bytesize;
        byte[] alleles = new byte[bytesize];
        try {
            if (this.m_genotypehandle.getFilePointer() != seekLoc) {
                this.m_genotypehandle.seek(seekLoc);
            }
            int len = this.m_genotypehandle.read(alleles, 0, bytesize);
        }
        catch (IOException e) {
            // empty catch block
        }
        System.arraycopy(alleles, 0, allele1, 0, this.m_numIndividuals);
        System.arraycopy(alleles, this.m_numIndividuals, allele2, 0, this.m_numIndividuals);
        alleles = null;
        snp.setAlleles(allele1, allele2, this.m_isIncluded, this.m_isFemale);
    }

    public void loadDosage(SNP snp) {
        if (this.m_dosagehandle != null) {
            int ind;
            byte[] dosageValues = new byte[this.m_numIndividuals];
            long seekLoc = (long)snp.getId() * (long)this.m_numIndividuals * 1L;
            try {
                this.m_dosagehandle.seek(seekLoc);
                int len = this.m_dosagehandle.read(dosageValues, 0, this.m_numIndividuals);
            }
            catch (IOException e) {
                // empty catch block
            }
            short[] genotypes = snp.getGenotypes();
            boolean takeComplement = false;
            for (ind = 0; ind < dosageValues.length; ++ind) {
                double dosagevalue = (double)(128 + dosageValues[ind]) / 100.0;
                if (genotypes[ind] == 0 && dosagevalue > 1.0) {
                    takeComplement = true;
                    break;
                }
                if (genotypes[ind] != 2 || !(dosagevalue < 1.0)) continue;
                takeComplement = true;
                break;
            }
            if (takeComplement) {
                for (ind = 0; ind < dosageValues.length; ++ind) {
                    byte dosageValue;
                    dosageValues[ind] = dosageValue = (byte)(200 - (128 + dosageValues[ind]) + -128);
                }
            }
            snp.setDosage(dosageValues);
        }
    }

    public int getNumIndividuals() {
        return this.m_numIndividuals;
    }

    public void setNumIndividuals(int numIndividuals) {
        this.m_numIndividuals = numIndividuals;
    }

    public boolean hasDosageInformation() {
        return this.m_dosagehandle != null;
    }

    public double getAverageSNPSize(int numSNPs) {
        long size = 0L;
        try {
            size += this.m_genotypehandle.length();
            if (this.m_dosagehandle != null) {
                size += this.m_dosagehandle.length();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        double avgSNPSize = 0.0;
        if (size > 0L) {
            avgSNPSize = (double)size / (double)numSNPs;
        }
        return avgSNPSize;
    }

    public void close() throws IOException {
        if (this.m_dosagehandle != null) {
            this.m_dosagehandle.close();
        }
        this.m_genotypehandle.close();
    }
}

