/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ui;

import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlSettings;
import org.molgenis.framework.ui.html.render.RenderDecorator;
import org.molgenis.ui.MolgenisComponent;
import org.molgenis.util.tuple.Tuple;

public abstract class HtmlInput<T extends HtmlInput<T, E>, E>
extends MolgenisComponent<HtmlInput<T, E>> {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String NILLABLE = "nillable";
    public static final String READONLY = "readonly";
    public static final String DESCRIPTION = "decription";
    public static final String HIDDEN = "hidden";
    public static final String JQUERYPROPERTIES = "Jqueryproperties";
    private String id;
    private String name;
    private E value;
    private String label;
    private boolean readonly;
    protected boolean hidden;
    private boolean nillable = true;
    private boolean collapse = false;
    private String tooltip;
    private String style;
    private Integer size;
    private String target = "";
    private String description = "";
    private String Jqueryproperties;
    protected String tabIndex = "";
    protected RenderDecorator renderDecorator = HtmlSettings.defaultRenderDecorator;

    public HtmlInput(String name, E value) {
        if (name == null) {
            name = UUID.randomUUID().toString().replace("-", "");
        }
        this.id(name.replace(" ", ""));
        this.setName(name.replace(" ", ""));
        this.id(name);
        this.setValue(value);
    }

    @Override
    public void set(Tuple t) throws HtmlInputException {
        this.id = t.getString(NAME);
        this.name = t.getString(NAME);
        this.value = t.get(VALUE);
        if (t.getBoolean(NILLABLE) != null) {
            this.nillable = t.getBoolean(NILLABLE);
        }
        if (t.getBoolean(READONLY) != null) {
            this.readonly = t.getBoolean(READONLY);
        }
        this.description = t.getString(DESCRIPTION);
        if (t.getBoolean(HIDDEN) != null) {
            this.hidden = t.getBoolean(HIDDEN);
        }
        this.Jqueryproperties = t.getString(JQUERYPROPERTIES);
    }

    protected HtmlInput() {
        this(UUID.randomUUID().toString(), null);
    }

    public String getLabel() {
        return this.label;
    }

    public T label(String label) {
        this.label = label;
        return (T)this;
    }

    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public E getObject() {
        return this.value;
    }

    public String getObjectString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getValue(boolean replaceSpecialChars) {
        if (this.getObject() == null) {
            return "";
        }
        return this.getObject().toString();
    }

    public String getHtmlValue(int maxLength) {
        StringBuilder strBuilder = new StringBuilder();
        boolean inTag = false;
        int count = 0;
        for (char c : this.getHtmlValue().toCharArray()) {
            if ('<' == c) {
                inTag = true;
            }
            if (inTag || count < maxLength) {
                strBuilder.append(c);
            }
            if ('>' == c) {
                inTag = false;
            }
            if (inTag) continue;
            ++count;
        }
        return strBuilder.toString();
    }

    public String getHtmlValue() {
        String value = null;
        value = this.getValue();
        return this.renderDecorator.render(value);
    }

    public String getJavaScriptValue() {
        String value = StringEscapeUtils.escapeXml((String)StringEscapeUtils.escapeEcmaScript((String)this.getValue()));
        return value;
    }

    public HtmlInput<T, E> setValue(E value) {
        this.value = value;
        return this;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public HtmlInput<T, E> setReadonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public HtmlInput<T, E> setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T id(String id) {
        this.id = id;
        return (T)this;
    }

    public String getStyle() {
        return this.style;
    }

    public HtmlInput<T, E> setStyle(String style) {
        this.style = style;
        return this;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public HtmlInput<T, E> setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public String getTarget() {
        return this.target.replace(".", "_");
    }

    public HtmlInput<T, E> setTarget(String target) {
        this.target = target.replace(".", "_");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HtmlInput<T, E> setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public HtmlInput<T, E> setNillable(boolean required) {
        this.nillable = required;
        return this;
    }

    public String getJqueryproperties() {
        return this.Jqueryproperties;
    }

    public void setJqueryproperties(String jqueryproperties) {
        this.Jqueryproperties = jqueryproperties;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
    }

    public synchronized Integer getSize() {
        return this.size;
    }

    public synchronized HtmlInput<T, E> setSize(Integer size) {
        this.size = size;
        return this;
    }

    public HtmlInput<T, E> setTabIndex(int tabidx) {
        this.tabIndex = " tabindex=" + Integer.toString(tabidx);
        return this;
    }
}

