/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.MolgenisModelParser;
import org.molgenis.model.MolgenisModelValidator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;

public class MolgenisModel {
    private static final Logger logger = Logger.getLogger(MolgenisModel.class);

    public static Model parse(MolgenisOptions options) throws Exception {
        Model model = null;
        try {
            logger.info((Object)("parsing db-schema from " + options.model_database));
            model = MolgenisModelParser.parseDbSchema(options.model_database);
            Model importedModel = MolgenisModelParser.parseDbSchema(options.import_model_database);
            MolgenisModelValidator.validate(importedModel, options);
            for (Entity importedEntity : importedModel.getEntities()) {
                importedEntity.setImported(true);
                importedEntity.setModel(model);
            }
            importedModel.getDatabase().setName("imported");
            for (Module importedModule : importedModel.getModules()) {
                model.getModules().add(importedModule);
                for (Entity importedEntity : importedModule.getEntities()) {
                    model.getDatabase().getTreeElements().remove(importedEntity.getName());
                    importedEntity.setParent(model.getDatabase());
                }
            }
            for (String eName : options.authorizable) {
                Vector<String> implNames = model.getEntity(eName = eName.trim()).getImplementsNames();
                if (implNames.contains("Authorizable")) continue;
                implNames.add("Authorizable");
                model.getEntity(eName).setImplements(implNames);
            }
            logger.info((Object)"read model");
            if (logger.isTraceEnabled()) {
                logger.trace((Object)model);
            }
            MolgenisModelValidator.validate(model, options);
            logger.info((Object)"parsing ui-schema");
            model = MolgenisModelParser.parseUiSchema(options.path + options.model_userinterface, model);
            MolgenisModelValidator.validateUI(model, options);
            logger.info((Object)"validated model");
            if (logger.isTraceEnabled()) {
                logger.trace((Object)model);
            }
        }
        catch (MolgenisModelException e) {
            logger.error((Object)("Parsing failed: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        return model;
    }

    public static Model parse(Properties p) throws Exception {
        MolgenisOptions options = new MolgenisOptions(p);
        return MolgenisModel.parse(options);
    }

    public static List<Entity> sortEntitiesByDependency(List<Entity> entityList, Model model) throws MolgenisModelException {
        ArrayList<Entity> result = new ArrayList<Entity>();
        boolean found = true;
        ArrayList<Entity> toBeMoved = new ArrayList<Entity>();
        while (entityList.size() > 0 && found) {
            found = false;
            for (Entity entity : entityList) {
                List<String> deps = MolgenisModel.getDependencies(entity, model);
                boolean missing = false;
                for (String dep : deps) {
                    if (MolgenisModel.indexOf(result, dep) >= 0) continue;
                    missing = true;
                    break;
                }
                if (missing) continue;
                toBeMoved.add(entity);
                result.add(entity);
                found = true;
                break;
            }
            for (Entity e : toBeMoved) {
                entityList.remove(e);
            }
            toBeMoved.clear();
        }
        for (Entity e : entityList) {
            logger.error((Object)("cyclic relations to '" + e.getName() + "' depends on " + MolgenisModel.getDependencies(e, model)));
            result.add(e);
        }
        for (Entity e : result) {
            logger.info((Object)e.getName());
        }
        return result;
    }

    private static int indexOf(List<Entity> entityList, String entityName) {
        for (int i = 0; i < entityList.size(); ++i) {
            if (!entityList.get(i).getName().equals(entityName)) continue;
            return i;
        }
        return -1;
    }

    private static List<String> getDependencies(Entity currentEntity, Model model) throws MolgenisModelException {
        HashSet<String> dependencies = new HashSet<String>();
        for (Field field : currentEntity.getAllFields()) {
            if (field.getType() instanceof XrefField) {
                dependencies.add(model.getEntity(field.getXrefEntityName()).getName());
                Entity xrefEntity = field.getXrefEntity();
                for (Entity e : xrefEntity.getAllDescendants()) {
                    if (dependencies.contains(e.getName())) continue;
                    dependencies.add(e.getName());
                }
            }
            if (!(field.getType() instanceof MrefField)) continue;
            dependencies.add(field.getXrefEntity().getName());
            for (String name : model.getEntity(field.getXrefEntity().getName()).getParents()) {
                dependencies.add(name);
            }
        }
        dependencies.remove(currentEntity.getName());
        return new ArrayList<String>(dependencies);
    }
}

