/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import org.molgenis.framework.ui.html.AbstractRefInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.Tuple;

@SuppressWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Always use \n for newlines")
public class MrefInput<E extends Entity>
extends AbstractRefInput<List<E>> {
    public MrefInput(String name, Class<? extends Entity> xrefEntityClass, List<E> dummyList) {
        super(name, xrefEntityClass, dummyList);
        this.setXrefEntity(xrefEntityClass);
    }

    public MrefInput(String name, List<E> objects) {
        this(name, ((Entity)objects.get(0)).getClass(), objects);
        this.setXrefField(name);
    }

    public MrefInput(String name, Class<? extends Entity> xrefEntityClass) {
        super(name, xrefEntityClass, null);
        this.setXrefEntity(xrefEntityClass);
    }

    @Deprecated
    public MrefInput(String name, String label, List<E> values, Boolean nillable, Boolean readonly, String description, Class<? extends Entity> xrefEntityClass) {
        super(name, xrefEntityClass, label, values, nillable, readonly, description);
        this.setXrefEntity(xrefEntityClass);
    }

    @Deprecated
    public MrefInput(String name, String label, List<E> values, Boolean nillable, Boolean readonly, String description, String xrefEntityClass) throws HtmlInputException, ClassNotFoundException {
        super(name, Class.forName(xrefEntityClass), label, values, nillable, readonly, description);
        this.setXrefEntity(xrefEntityClass);
    }

    public MrefInput(Tuple t) throws HtmlInputException {
        super(t);
    }

    protected MrefInput() {
    }

    @Override
    public String getValue() {
        StringBuilder strBuilder = new StringBuilder();
        for (Entity value : (List)this.getObject()) {
            if (strBuilder.length() == 0) {
                strBuilder.append(value.getLabelValue());
                continue;
            }
            strBuilder.append(", ").append(value.getLabelValue());
        }
        return strBuilder.toString();
    }

    @Override
    public String toHtml(Tuple params) throws HtmlInputException {
        return new MrefInput<E>(params).render();
    }

    @Override
    protected String renderOptions() {
        String option = "\t<option selected value=\"%s\">%s</option>\n";
        StringBuilder result = new StringBuilder();
        for (Entity value : (List)this.getObject()) {
            result.append(String.format("\t<option selected value=\"%s\">%s</option>\n", value.getIdValue(), value.getLabelValue()));
        }
        return result.toString();
    }

    @Override
    protected String getHtmlRefType() {
        return "multiple";
    }

    @Override
    public String renderHidden() {
        StringBuilder strBuilder = new StringBuilder();
        for (Entity object : (List)this.getObject()) {
            strBuilder.append("<input name=\"").append(this.getName()).append("\" type=\"hidden\" value=\"");
            strBuilder.append(object.getIdValue()).append("\"/>");
        }
        return strBuilder.toString();
    }
}

