/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.HtmlForm;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.OnoffInput;
import org.molgenis.util.tuple.Tuple;

public class ListView
extends HtmlInput<List<HtmlForm>> {
    List<HtmlForm> rows = new ArrayList<HtmlForm>();
    String sortedBy = null;
    QueryRule.Operator sortOrder = QueryRule.Operator.SORTDESC;
    boolean selectable = true;
    int offset = 0;

    public ListView(String name, List<HtmlForm> rows) {
        super(name, null);
        this.setRows(rows);
        this.setReadonly(true);
    }

    public ListView(String name) {
        super(name, null);
        this.setReadonly(true);
    }

    public void setRows(List<HtmlForm> rows) {
        if (rows == null) {
            throw new IllegalArgumentException("GridPanel.setRows cannot be null");
        }
        this.rows = rows;
    }

    public List<HtmlForm> getRows() {
        return this.rows;
    }

    public ListView setValue(List<HtmlForm> value) {
        this.setRows(value);
        return this;
    }

    @Override
    public String getValue() {
        return this.toHtml();
    }

    public String getSortedBy() {
        return this.sortedBy;
    }

    public void setSortedBy(String sortedBy) {
        this.sortedBy = sortedBy;
    }

    public QueryRule.Operator getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(QueryRule.Operator sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void addRow(HtmlForm ... forms) {
        for (HtmlForm f : forms) {
            this.getRows().add(f);
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public String toHtml() {
        StringBuilder strBuilder = new StringBuilder("<table class=\"listtable\">");
        int rowNo = 1;
        for (HtmlForm form : this.getRows()) {
            if (rowNo == 1) {
                strBuilder.append("<tr><th><label>&nbsp;</label></th><th><label>&nbsp;</label></th><th><label>&nbsp;</label></th>");
                for (HtmlInput<?> input : form.getInputs()) {
                    if (input.isHidden()) continue;
                    ActionInput actionInput = new ActionInput(QueryRule.Operator.SORTASC.equals((Object)this.getSortOrder()) ? "sortDesc" : "sortAsc");
                    actionInput.setLabel(input.getLabel());
                    actionInput.setDescription(input.getDescription());
                    actionInput.setIcon(QueryRule.Operator.SORTASC.equals((Object)this.getSortOrder()) ? "img/sort_desc.gif" : "img/sort_asc.gif");
                    strBuilder.append("<th><label class=\"tableheader\">").append(actionInput.toLinkHtml());
                    strBuilder.append(input.getName().equals(this.getSortedBy()) ? actionInput.getIconHtml() : "");
                    strBuilder.append("</label></th>");
                }
                strBuilder.append("</tr>");
            }
            strBuilder.append("<tr class=\"form_listrow").append(rowNo % 2).append("\">");
            strBuilder.append("<td>").append(this.getOffset() + rowNo).append(".</td>");
            OnoffInput checkbox = new OnoffInput("massUpdate", "TODO", false);
            strBuilder.append("<td>").append(this.isSelectable() ? checkbox.toHtml() : "").append("</td>");
            strBuilder.append("<td>");
            for (ActionInput actionInput : form.getActions()) {
                strBuilder.append(actionInput.toIconHtml());
            }
            strBuilder.append("</td>");
            for (HtmlInput htmlInput : form.getInputs()) {
                if (htmlInput.isHidden()) continue;
                strBuilder.append("<td title=\"").append(htmlInput.getDescription()).append("\">");
                strBuilder.append(this.isReadonly() ? htmlInput.getValue() : htmlInput.toHtml()).append("</td>");
            }
            strBuilder.append("</tr>");
            ++rowNo;
        }
        strBuilder.append("<tr><td></td><td><input title=\"select all visible\" type=\"checkbox\" name=\"checkall\" id=\"checkall\" onclick=\"Javascript:checkAll('TODO','massUpdate')\"/></td></tr>");
        strBuilder.append("</table>");
        return strBuilder.toString();
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        throw new UnsupportedOperationException();
    }
}

