/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.util.Entity;

public class EntityTable
extends HtmlWidget {
    Collection<? extends Entity> entities;
    List<String> columns;
    private boolean editButton;

    public EntityTable(Collection<? extends Entity> entities, boolean editButton, String ... columns) {
        this(UUID.randomUUID().toString(), entities, editButton, columns);
    }

    public EntityTable(String name, Collection<? extends Entity> entities) {
        this(name, entities, false, new String[0]);
    }

    public EntityTable(String name, Collection<? extends Entity> entities, boolean editButton, String ... columns) {
        block1: {
            block0: {
                super(name);
                this.entities = null;
                this.columns = null;
                this.editButton = false;
                this.entities = entities;
                this.editButton = editButton;
                if (columns == null || columns.length <= 0) break block0;
                this.columns = Arrays.asList(columns);
                break block1;
            }
            Iterator<? extends Entity> i$ = entities.iterator();
            if (!i$.hasNext()) break block1;
            Entity e = i$.next();
            this.columns = e.getFields();
        }
    }

    @Override
    public String toHtml() {
        StringBuilder htmlBuilder = new StringBuilder("<table class=\"listtable\">");
        htmlBuilder.append("<thead><tr>");
        for (String column : this.columns) {
            htmlBuilder.append("<td>").append(column).append("</td>");
        }
        htmlBuilder.append("</tr></thead>");
        int color = 0;
        for (Entity entity : this.entities) {
            htmlBuilder.append("<tr class=\"form_listrow").append(color).append("\" id=\"").append(entity.getIdValue()).append("\">");
            color = color == 0 ? 1 : 0;
            for (String column : this.columns) {
                htmlBuilder.append("<td>");
                if (entity.get(column) != null) {
                    htmlBuilder.append(entity.get(column).toString().replace(">", "&gt;").replace("<", "&lt;").replace("\n", "<br/>"));
                }
                htmlBuilder.append("</td>");
            }
            if (this.editButton) {
                htmlBuilder.append("<td><img class=\"edit_button\" src=\"img/editview.gif\" title=\"edit record\"");
                htmlBuilder.append("onclick=\"submitFormMethod('").append(entity.getIdValue()).append("');\"></td>");
            }
            htmlBuilder.append("</tr>");
        }
        htmlBuilder.append("</table>");
        return htmlBuilder.toString();
    }
}

