/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.ArrayList;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;

public class EntityDataTable
extends HtmlWidget {
    String klazzName;
    Entity entityModel;

    public EntityDataTable(String name, Class<? extends org.molgenis.util.Entity> entityClass, Database db) throws DatabaseException {
        super(name);
        this.entityModel = db.getMetaData().getEntity(entityClass.getSimpleName());
        this.klazzName = entityClass.getName();
    }

    @Override
    public String toHtml() {
        ArrayList<String> labels = new ArrayList<String>();
        try {
            for (Field field : this.entityModel.getAllFields()) {
                if (field.getType() instanceof XrefField || field.getType() instanceof MrefField) {
                    for (String label : field.getXrefLabelNames()) {
                        labels.add(field.getName() + "_" + label);
                    }
                    continue;
                }
                labels.add(field.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<table id=\"").append(this.getName()).append("\"><thead>");
        for (String label : labels) {
            strBuilder.append("<td>").append(label).append("</td>");
        }
        strBuilder.append("</thead></table>");
        strBuilder.append("\n<script>");
        strBuilder.append("var oTable = $('#").append(this.getName()).append("').dataTable({");
        strBuilder.append("\n\t'bJQueryUI' : true,");
        strBuilder.append("\n\t'bServerSide' : true,");
        strBuilder.append("\n\t'sAjaxSource' : 'datatable',");
        strBuilder.append("\n\t'bPagination' : true,");
        strBuilder.append("\n\t'sScrollX': '100%',");
        strBuilder.append("\n\t'bScrollCollapse': true,");
        strBuilder.append("\n\t'bProcessing' : true,");
        strBuilder.append("\n\t'aoColumns' : [");
        for (String label : labels) {
            strBuilder.append("{ 'mDataProp' : '").append(label).append("'}").append(',');
        }
        if (!labels.isEmpty()) {
            strBuilder.deleteCharAt(strBuilder.length() - 1);
        }
        strBuilder.append("\t],");
        strBuilder.append("\t'fnServerParams' : function(aoData) {");
        strBuilder.append("\n\taoData.push({");
        strBuilder.append("\n\t\t'name' : 'entity',");
        strBuilder.append("\n\t\t'value' : '").append(this.klazzName).append('\'');
        strBuilder.append("\n\t});");
        strBuilder.append("\n}");
        strBuilder.append("});");
        strBuilder.append("\nnew FixedColumns(oTable, {'iLeftWidth' : 200});");
        strBuilder.append("</script>");
        return strBuilder.toString();
    }
}

