/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.molgenis.framework.ui.JQueryDateFormatMapper;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class DateInput
extends HtmlInput<Date> {
    public static final String DATEFORMAT = "dateformat";
    private String javaDataFormat = "dd-MM-yyyy";

    public DateInput(String name) {
        this(name, name, Calendar.getInstance().getTime());
    }

    public DateInput(String name, String label) {
        super(name, null);
        this.setLabel(label);
    }

    public DateInput(String name, Date value) {
        super(name, value);
    }

    public DateInput(String name, String label, Date value) {
        super(name, value);
        this.setLabel(label);
    }

    public DateInput(String name, String label, Date value, boolean nillable, boolean readonly) {
        super(name, value);
        if (label != null && !label.equals("null")) {
            this.setLabel(label);
        }
        this.setReadonly(readonly);
        this.setNillable(nillable);
    }

    public DateInput(Tuple properties) throws HtmlInputException {
        this.set(properties);
    }

    public DateInput(String name, String label, Date value, boolean nillable, boolean readonly, String dateformat, String jqueryproperties) throws HtmlInputException {
        super(name, value);
        if (label != null && !label.equals("null")) {
            this.setLabel(label);
        }
        this.setReadonly(readonly);
        this.setNillable(nillable);
        this.setDateFormat(dateformat);
        this.setJqueryproperties(jqueryproperties);
    }

    protected DateInput() {
    }

    @Override
    public String toHtml() {
        if (this.uiToolkit == HtmlElement.UiToolkit.JQUERY) {
            return this.toJquery();
        }
        return this.toDefault();
    }

    private String toDefault() {
        String readonly;
        String string = readonly = this.isReadonly() ? " class=\"readonly\" readonly " : "onclick=\"showDateInput(this) ";
        if (this.isHidden()) {
            StringInput input = new StringInput(this.getName(), this.getValue());
            input.setHidden(true);
            return input.toHtml();
        }
        return "<input type=\"text\" id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" value=\"" + this.getObjectString() + "\" " + readonly + "\" size=\"32\" autocomplete=\"off\"/>";
    }

    public String getValue(String format) {
        String result;
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.US);
        Object dateObject = this.getObject();
        if (dateObject == null) {
            return "";
        }
        if (dateObject.equals("")) {
            return "";
        }
        if (dateObject instanceof String) {
            return dateObject.toString();
        }
        try {
            result = formatter.format(dateObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        result = result.substring(0, 1).toUpperCase() + result.substring(1);
        return result;
    }

    @Override
    public String getValue() {
        return this.getValue("MMMM d, yyyy");
    }

    public String toJquery() {
        String description = this.getName().equals(this.getDescription()) ? "" : " title=\"" + this.getDescription() + "\"";
        String options = "dateFormat: '" + JQueryDateFormatMapper.toJQueryDateFormat(this.getDateFormat(), this.getDateFormat()) + "', changeMonth: true, changeYear: true, showButtonPanel: true";
        String datevalue = this.getValue(this.getDateFormat());
        if (this.getJqueryproperties() != null) {
            options = this.getJqueryproperties();
        }
        if (this.isNillable()) {
            options = options + ", beforeShow: function( input ) {\n\tsetTimeout( function() {\n\t\tvar buttonPane = $( input ).datepicker( \"widget\" ).find( \".ui-datepicker-buttonpane\" );\n\t\t$( \"<button>\", {text: \"Clear\", click: function() {$.datepicker._clearDate( input );}}).addClass(\"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\").appendTo( buttonPane );\n\t}, 1 );\n}";
        }
        String validate = "";
        if (!this.isNillable()) {
            validate = " required";
        }
        String result = "<input type=\"text\" readonly=\"readonly\" class=\"" + (this.isReadonly() ? "readonly " : "") + "text ui-widget-content ui-corner-all" + validate + "\" id=\"" + this.getName() + "\" value=\"" + datevalue + "\" name=\"" + this.getName() + "\" autocomplete=\"off\"" + description + " />";
        if (!this.isReadonly()) {
            result = result + "<script>\n\t$(\"#" + this.getId() + "\").bt().datepicker({" + options + "}).click(function(){$(this).datepicker('show')});" + "\n</script>";
        }
        return result;
    }

    @Override
    public String toHtml(Tuple p) throws ParseException, HtmlInputException {
        return new DateInput(p).render();
    }

    public String getDateFormat() {
        return this.javaDataFormat;
    }

    public void setDateFormat(String dateformat) {
        this.javaDataFormat = dateformat;
    }
}

