/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.TreeMap;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.html.StringInput;

public class CodeInput
extends StringInput {
    private Parser parser = Parser.FREEMARKER;

    public CodeInput(String name) {
        this(name, null, Parser.FREEMARKER);
    }

    public CodeInput(String name, String value, Parser parser) {
        super(name, value);
        this.parser = parser;
        this.setMaxHeight(50);
        this.setMinHeight(3);
    }

    protected CodeInput() {
    }

    public String getParser() {
        return this.parser.getPath();
    }

    public String getParserStyle() {
        return this.parser.getCssPath();
    }

    @Override
    public String toHtml() {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("input", this);
        return new FreemarkerView("org/molgenis/framework/ui/html/CodeInput.ftl", parameters).render();
    }

    public static enum Parser {
        FREEMARKER("\"../contrib/freemarker/js/parsefreemarker.js\"", "css/freemarkercolors.css"),
        JAVA("[\"../contrib/java/js/tokenizejava.js\",\"../contrib/java/js/parsejava.js\"]", "lib/codemirror-1.0/contrib/java/css/javacolors.css");

        private final String path;
        private final String css;

        private Parser(String path, String css) {
            this.path = path;
            this.css = css;
        }

        public String getPath() {
            return this.path;
        }

        public String getCssPath() {
            return this.css;
        }
    }
}

